/*
 * Decompiled with CFR 0.152.
 */
package sdloader.javaee.impl;

import java.util.Map;
import javax.servlet.http.HttpSession;
import sdloader.javaee.InternalWebApplication;
import sdloader.javaee.SessionManager;
import sdloader.javaee.impl.HttpSessionImpl;
import sdloader.util.CollectionsUtil;
import sdloader.util.DisposableUtil;

public class SessionManagerImpl
extends SessionManager
implements DisposableUtil.Disposable {
    protected Map<String, HttpSessionImpl> sessionMap = CollectionsUtil.newConcurrentHashMap();

    public SessionManagerImpl() {
        DisposableUtil.add(this);
    }

    public synchronized HttpSession getSession(String sessionId, boolean createNew, InternalWebApplication webApplication) {
        if (sessionId == null) {
            return this.createNewSession(webApplication);
        }
        HttpSessionImpl session = this.sessionMap.get(sessionId);
        if (session != null) {
            if (!session.isInvalidate()) {
                return session;
            }
            session.invalidate();
            this.sessionMap.remove(sessionId);
            if (createNew) {
                return this.createNewSession(webApplication);
            }
            return null;
        }
        if (createNew) {
            return this.createNewSession(webApplication);
        }
        return null;
    }

    protected HttpSession createNewSession(InternalWebApplication webApplication) {
        String sessionId = this.createNewSessionId();
        HttpSessionImpl ses = new HttpSessionImpl(webApplication, sessionId);
        this.sessionMap.put(sessionId, ses);
        return ses;
    }

    public void dispose() {
        for (HttpSessionImpl session : this.sessionMap.values()) {
            session.invalidate();
        }
        this.sessionMap.clear();
    }
}

