/*
 * Decompiled with CFR 0.152.
 */
package sdloader.javaee.impl;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;
import sdloader.javaee.InternalWebApplication;
import sdloader.javaee.ListenerEventDispatcher;
import sdloader.javaee.ServletMapping;
import sdloader.javaee.constants.JavaEEConstants;
import sdloader.javaee.impl.RequestDispatcherImpl;
import sdloader.javaee.impl.ServletConfigImpl;
import sdloader.log.SDLoaderLog;
import sdloader.log.SDLoaderLogFactory;
import sdloader.util.CollectionsUtil;
import sdloader.util.IteratorEnumeration;
import sdloader.util.MimeParseHandler;
import sdloader.util.PathUtil;
import sdloader.util.ResourceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletContextImpl
implements ServletContext {
    private static final SDLoaderLog log = SDLoaderLogFactory.getLog(ServletConfigImpl.class);
    private InternalWebApplication webApp;
    private String servletContextName;
    private URL[] docBase;
    private Map<String, Servlet> servletMap;
    private Map<String, Object> attributeMap = CollectionsUtil.newHashMap();
    private Map<String, String> initParamMap = CollectionsUtil.newHashMap();
    protected Map<String, String> mimeTypeMap;

    public ServletContextImpl(InternalWebApplication webapp) {
        InputStream is = ResourceUtil.getResourceAsStream("/sdloader/resource/mime.xml", this.getClass());
        if (is == null) {
            throw new ExceptionInInitializerError("mime.xml not found.");
        }
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            MimeParseHandler handler = new MimeParseHandler();
            parser.parse(is, (DefaultHandler)handler);
            this.mimeTypeMap = handler.getMimeMap();
        }
        catch (Exception se) {
            throw new ExceptionInInitializerError("Mime parse fail. " + se.getMessage());
        }
        this.webApp = webapp;
    }

    @Override
    public ServletContext getContext(String contextPath) {
        InternalWebApplication webapp = this.webApp.getWebApplicationManager().findWebApp(contextPath);
        if (webapp != null) {
            return webapp.getServletContext();
        }
        return null;
    }

    @Override
    public Set<String> getResourcePaths(String path) {
        String absPath;
        File targetResource;
        if (path == null) {
            return null;
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((targetResource = new File(absPath = this.docBase + path)).exists()) {
            HashSet<String> pathSet = CollectionsUtil.newHashSet();
            if (targetResource.isDirectory()) {
                File[] resources = targetResource.listFiles();
                if (resources != null) {
                    for (int i = 0; i < resources.length; ++i) {
                        File resource = resources[i];
                        String name = path + "/" + resource.getName();
                        if (resource.isDirectory()) {
                            name = name + "/";
                        }
                        pathSet.add(name);
                    }
                }
            } else {
                String name = path + "/" + targetResource.getName();
                pathSet.add(name);
            }
            if (!pathSet.isEmpty()) {
                return pathSet;
            }
        }
        return null;
    }

    @Override
    public URL getResource(String resource) throws MalformedURLException {
        URL url = null;
        if (ResourceUtil.isAbsoluteURL(resource)) {
            url = new URL(resource);
            return ResourceUtil.isResourceExist(url) ? url : null;
        }
        for (int i = 0; i < this.docBase.length; ++i) {
            url = ResourceUtil.createURL(this.docBase[i], resource);
            if (!ResourceUtil.isResourceExist(url)) continue;
            return url;
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String resource) {
        try {
            URL url = this.getResource(resource);
            if (url != null) {
                return url.openStream();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Servlet getServlet(String name) throws ServletException {
        if (this.servletMap == null) {
            return null;
        }
        return this.servletMap.get(name);
    }

    @Override
    public Enumeration<Servlet> getServlets() {
        if (this.servletMap == null) {
            return new IteratorEnumeration<Servlet>();
        }
        return new IteratorEnumeration<Servlet>(this.servletMap.values().iterator());
    }

    @Override
    public Enumeration<String> getServletNames() {
        if (this.servletMap == null) {
            return new IteratorEnumeration<String>();
        }
        return new IteratorEnumeration<String>(this.servletMap.keySet().iterator());
    }

    @Override
    public String getRealPath(String resource) {
        if (this.docBase.length == 0) {
            URL url = ResourceUtil.createURL(this.docBase[0], resource);
            return this.toRealPath(url);
        }
        for (int i = 0; i < this.docBase.length; ++i) {
            URL url = ResourceUtil.createURL(this.docBase[i], resource);
            if (!ResourceUtil.isResourceExist(url)) continue;
            return this.toRealPath(url);
        }
        URL url = ResourceUtil.createURL(this.docBase[0], resource);
        return this.toRealPath(url);
    }

    protected String toRealPath(URL url) {
        if (url.getProtocol().startsWith("file")) {
            return url.getFile();
        }
        return url.toExternalForm();
    }

    @Override
    public String getInitParameter(String key) {
        return this.initParamMap.get(key);
    }

    @Override
    public Enumeration<String> getInitParameterNames() {
        return new IteratorEnumeration<String>(this.initParamMap.keySet().iterator());
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributeMap.get(key);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return new IteratorEnumeration<String>(this.attributeMap.keySet().iterator());
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("ServletContext attribute key is null.");
        }
        if (value == null) {
            this.removeAttribute(key);
        } else {
            Object oldValue = this.attributeMap.get(key);
            ListenerEventDispatcher dispatcher = this.webApp.getListenerEventDispatcher();
            if (oldValue == null) {
                this.attributeMap.put(key, value);
                ServletContextAttributeEvent event = new ServletContextAttributeEvent(this, key, value);
                dispatcher.dispatchServletContextAttributeListener_attributeAdded(event);
            } else if (oldValue != value) {
                this.attributeMap.put(key, value);
                ServletContextAttributeEvent event = new ServletContextAttributeEvent(this, key, oldValue);
                dispatcher.dispatchServletContextAttributeListener_attributeReplaced(event);
            }
        }
    }

    @Override
    public void removeAttribute(String key) {
        Object value = this.attributeMap.remove(key);
        if (value != null) {
            ServletContextAttributeEvent event = new ServletContextAttributeEvent(this, key, value);
            ListenerEventDispatcher dispatcher = this.webApp.getListenerEventDispatcher();
            dispatcher.dispatchServletContextAttributeListener_attributeRemoved(event);
        }
    }

    @Override
    public String getServletContextName() {
        return this.servletContextName;
    }

    @Override
    public void log(String logValue) {
        log.info(logValue);
    }

    @Override
    public void log(Exception ex, String logValue) {
        log.info(logValue, ex);
    }

    @Override
    public void log(String logValue, Throwable t) {
        log.info(logValue, t);
    }

    @Override
    public int getMajorVersion() {
        return JavaEEConstants.SERVLETAPI_MAJOR_VERSION;
    }

    @Override
    public int getMinorVersion() {
        return JavaEEConstants.SERVLETAPI_MINOR_VERSION;
    }

    @Override
    public String getMimeType(String path) {
        String ext = PathUtil.getExtension(path);
        if (ext == null) {
            return this.mimeTypeMap.get(path.toLowerCase());
        }
        return this.mimeTypeMap.get(ext.toLowerCase());
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String requestPath) {
        if (!PathUtil.startsWithSlash(requestPath)) {
            throw new IllegalArgumentException("dispatch path is not start with \"/\".");
        }
        InternalWebApplication webapp = this.webApp.getWebApplicationManager().findWebApp(this.servletContextName);
        ServletMapping mapping = webapp.findServletMapping(requestPath);
        if (mapping == null) {
            return null;
        }
        String servletName = mapping.getServletName();
        Servlet servlet = webapp.findServlet(servletName);
        List<Filter> forwardFilters = webapp.findFilters(requestPath, servletName, "FORWARD");
        List<Filter> includeFilters = webapp.findFilters(requestPath, servletName, "INCLUDE");
        String contextPath = webapp.getContextPath();
        String requestURI = PathUtil.jointPathWithSlash(contextPath, requestPath);
        return new RequestDispatcherImpl(mapping, servlet, forwardFilters, includeFilters, webapp.getServletContext(), contextPath, requestURI);
    }

    @Override
    public RequestDispatcher getNamedDispatcher(String servletName) {
        return null;
    }

    @Override
    public String getServerInfo() {
        return "SDLoader";
    }

    @Override
    public String getContextPath() {
        return this.servletContextName;
    }

    public void setServletMap(Map<String, Servlet> servletMap) {
        this.servletMap = servletMap;
    }

    public void addInitParameter(String paramName, String paramValue) {
        this.initParamMap.put(paramName, paramValue);
    }

    public void setServletContextName(String servletContextName) {
        this.servletContextName = servletContextName;
    }

    public void setDocBase(URL[] absoluteContextPath) {
        this.docBase = absoluteContextPath;
    }

    public InternalWebApplication getWebApplication() {
        return this.webApp;
    }
}

