/*
 * Decompiled with CFR 0.152.
 */
package sdloader.javaee.impl;

import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import sdloader.javaee.ServletMapping;
import sdloader.javaee.impl.FilterChainImpl;
import sdloader.javaee.impl.ForwardRequestWrapper;
import sdloader.javaee.impl.HttpServletRequestImpl;
import sdloader.javaee.impl.IncludeRequestWrapper;
import sdloader.javaee.impl.IncludeResponseWrapper;
import sdloader.util.WebUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestDispatcherImpl
implements RequestDispatcher {
    private ServletContext dispatchServletContext;
    private Servlet dispatchServlet;
    private List<Filter> forwardFilterList;
    private List<Filter> includeFilterList;
    private ServletMapping dispatchServletMapping;
    private String contextPath;
    private String requestURI;
    private String queryString;

    RequestDispatcherImpl(ServletMapping dispatchServletMapping, Servlet dispatchServlet, List<Filter> forwardFilterList, List<Filter> includeFilterList, ServletContext dispatchServletContext, String contextPath, String dispatchURI) {
        this.dispatchServletContext = dispatchServletContext;
        this.dispatchServletMapping = dispatchServletMapping;
        this.dispatchServlet = dispatchServlet;
        this.forwardFilterList = forwardFilterList;
        this.includeFilterList = includeFilterList;
        this.contextPath = contextPath;
        this.requestURI = WebUtil.stripQueryPart(dispatchURI);
        this.queryString = WebUtil.getQueryPart(dispatchURI);
    }

    private HttpServletRequestImpl stripRequestWrapper(ServletRequest request) {
        while (request instanceof HttpServletRequestWrapper) {
            request = ((HttpServletRequestWrapper)request).getRequest();
        }
        return (HttpServletRequestImpl)request;
    }

    @Override
    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequestImpl firstRequest = this.stripRequestWrapper(request);
        if (request.getAttribute("javax.servlet.forward.servlet_path") == null) {
            firstRequest.setAttribute("javax.servlet.forward.request_uri", firstRequest.getRequestURI());
            firstRequest.setAttribute("javax.servlet.forward.context_path", firstRequest.getContextPath());
            firstRequest.setAttribute("javax.servlet.forward.servlet_path", firstRequest.getServletPath());
            firstRequest.setAttribute("javax.servlet.forward.path_info", firstRequest.getPathInfo());
            firstRequest.setAttribute("javax.servlet.forward.query_string", firstRequest.getQueryString());
        }
        String resourcePath = WebUtil.getResourcePath(this.contextPath, this.requestURI);
        String servletPath = WebUtil.getServletPath(this.dispatchServletMapping.getUrlPattern(), resourcePath);
        String pathInfo = WebUtil.getPathInfo(this.dispatchServletMapping.getUrlPattern(), resourcePath);
        ForwardRequestWrapper requestWrapper = new ForwardRequestWrapper((HttpServletRequest)request);
        requestWrapper.setServletContext(this.dispatchServletContext);
        requestWrapper.setRequestURI(this.requestURI);
        requestWrapper.setServletPath(servletPath);
        requestWrapper.setPathInfo(pathInfo);
        requestWrapper.setContextPath(this.contextPath);
        response.resetBuffer();
        this.doService(this.dispatchServlet, this.forwardFilterList, requestWrapper, response);
    }

    @Override
    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        IncludeRequestWrapper requestWrapper = new IncludeRequestWrapper((HttpServletRequest)request);
        IncludeResponseWrapper responseWrapper = new IncludeResponseWrapper((HttpServletResponse)response);
        String resourcePath = WebUtil.getResourcePath(this.contextPath, this.requestURI);
        String servletPath = WebUtil.getServletPath(this.dispatchServletMapping.getUrlPattern(), resourcePath);
        String pathInfo = WebUtil.getPathInfo(this.dispatchServletMapping.getUrlPattern(), resourcePath);
        requestWrapper.setIncludeAttribute("javax.servlet.include.request_uri", this.requestURI);
        requestWrapper.setIncludeAttribute("javax.servlet.include.context_path", this.contextPath);
        requestWrapper.setIncludeAttribute("javax.servlet.include.servlet_path", servletPath);
        requestWrapper.setIncludeAttribute("javax.servlet.include.path_info", pathInfo);
        requestWrapper.setIncludeAttribute("javax.servlet.include.query_string", this.queryString);
        this.doService(this.dispatchServlet, this.includeFilterList, requestWrapper, responseWrapper);
    }

    private void doService(Servlet servlet, List<Filter> filterList, ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (filterList.size() > 0) {
            Filter[] filters = filterList.toArray(new Filter[0]);
            FilterChainImpl filterChain = new FilterChainImpl(filters, servlet);
            filterChain.doFilter(request, response);
        } else {
            servlet.service(request, response);
        }
    }
}

