/*
 * Decompiled with CFR 0.152.
 */
package sdloader.javaee.impl;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import sdloader.util.CollectionsUtil;
import sdloader.util.IteratorEnumeration;

public class IncludeRequestWrapper
extends HttpServletRequestWrapper {
    private Map<String, Object> includeAttributeMap = CollectionsUtil.newHashMap();
    private Map<String, String[]> includeParameterMap = CollectionsUtil.newHashMap();

    public IncludeRequestWrapper(HttpServletRequest req) {
        super(req);
    }

    void setIncludeAttribute(String key, Object value) {
        this.includeAttributeMap.put(key, value);
    }

    void addIncludeParameter(String key, String value) {
        String[] params;
        if (value == null) {
            value = "";
        }
        if ((params = this.includeParameterMap.get(key)) == null) {
            params = new String[]{value};
        } else {
            String[] newParams = new String[params.length + 1];
            System.arraycopy(params, 0, newParams, 0, params.length);
            newParams[newParams.length - 1] = value;
            params = newParams;
        }
        this.includeParameterMap.put(key, params);
    }

    public String getParameter(String name) {
        String param = null;
        String[] includeParam = this.includeParameterMap.get(name);
        if (includeParam != null) {
            param = includeParam[0];
        }
        if (param == null) {
            param = super.getParameter(name);
        }
        return param;
    }

    public String[] getParameterValues(String name) {
        String[] values;
        ArrayList<String> paramValues = CollectionsUtil.newArrayList();
        String[] includeValues = this.includeParameterMap.get(name);
        if (includeValues != null) {
            for (int i = 0; i < includeValues.length; ++i) {
                paramValues.add(includeValues[i]);
            }
        }
        if ((values = super.getParameterValues(name)) != null) {
            for (int i = 0; i < values.length; ++i) {
                paramValues.add(values[i]);
            }
        }
        return paramValues.size() == 0 ? null : paramValues.toArray(new String[0]);
    }

    public Enumeration getParameterNames() {
        Enumeration names = super.getParameterNames();
        HashSet<String> includeNames = new HashSet<String>(this.includeParameterMap.keySet());
        if (names != null) {
            while (names.hasMoreElements()) {
                includeNames.add((String)names.nextElement());
            }
        }
        return new IteratorEnumeration(includeNames.iterator());
    }

    public Map getParameterMap() {
        HashMap<String, String[]> paramMap = CollectionsUtil.newHashMap();
        Enumeration names = this.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            paramMap.put(name, this.getParameterValues(name));
        }
        return paramMap;
    }

    public Object getAttribute(String name) {
        Object value = this.includeAttributeMap.get(name);
        if (value == null) {
            value = super.getAttribute(name);
        }
        return value;
    }

    public Enumeration getAttributeNames() {
        Enumeration names = super.getAttributeNames();
        HashSet<String> includeNames = new HashSet<String>(this.includeAttributeMap.keySet());
        if (names != null) {
            while (names.hasMoreElements()) {
                includeNames.add((String)names.nextElement());
            }
        }
        return new IteratorEnumeration(includeNames.iterator());
    }
}

