/*
 * Decompiled with CFR 0.152.
 */
package sdloader.javaee.impl;

import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import sdloader.javaee.InternalWebApplication;
import sdloader.javaee.ListenerEventDispatcher;
import sdloader.log.SDLoaderLog;
import sdloader.log.SDLoaderLogFactory;
import sdloader.util.CollectionsUtil;
import sdloader.util.IteratorEnumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpSessionImpl
implements HttpSession {
    private static SDLoaderLog log = SDLoaderLogFactory.getLog(HttpSessionImpl.class);
    private String id;
    private long creationTime;
    private long lastAccessedTime;
    private int maxInactiveInterval;
    private Map<String, Object> attributeMap = CollectionsUtil.newHashMap();
    private boolean invalidate = false;
    private boolean isNew = true;
    private InternalWebApplication internalWebApplication;

    public HttpSessionImpl(InternalWebApplication webApp, String sessionId) {
        this.id = sessionId;
        this.creationTime = System.currentTimeMillis();
        this.internalWebApplication = webApp;
        this.dispatchCreateEvent();
    }

    @Override
    public long getCreationTime() {
        this.checkInvalidate();
        return this.creationTime;
    }

    @Override
    public String getId() {
        this.checkInvalidate();
        return this.id;
    }

    @Override
    public long getLastAccessedTime() {
        this.checkInvalidate();
        return this.lastAccessedTime;
    }

    @Override
    public ServletContext getServletContext() {
        this.checkInvalidate();
        return this.internalWebApplication.getServletContext();
    }

    @Override
    public void setMaxInactiveInterval(int interval) {
        this.checkInvalidate();
        this.maxInactiveInterval = interval;
    }

    @Override
    public int getMaxInactiveInterval() {
        this.checkInvalidate();
        return this.maxInactiveInterval;
    }

    @Override
    public HttpSessionContext getSessionContext() {
        throw new RuntimeException("getSessionConetxt not implemented");
    }

    @Override
    public Object getAttribute(String key) {
        this.checkInvalidate();
        return this.attributeMap.get(key);
    }

    @Override
    public Object getValue(String key) {
        this.checkInvalidate();
        return this.getAttribute(key);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        this.checkInvalidate();
        return new IteratorEnumeration<String>(this.attributeMap.keySet().iterator());
    }

    @Override
    public String[] getValueNames() {
        this.checkInvalidate();
        return this.attributeMap.keySet().toArray(new String[0]);
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.checkInvalidate();
        if (key == null) {
            throw new IllegalArgumentException("Session attribute key is null.");
        }
        if (value == null) {
            this.removeAttribute(key);
        } else {
            Object oldValue = this.attributeMap.get(key);
            if (value == oldValue) {
                return;
            }
            if (value instanceof HttpSessionBindingListener) {
                HttpSessionBindingEvent boundEvent = new HttpSessionBindingEvent(this, key, value);
                try {
                    ((HttpSessionBindingListener)value).valueBound(boundEvent);
                }
                catch (Throwable t) {
                    log.error(t.getMessage(), t);
                }
            }
            this.attributeMap.put(key, value);
            ListenerEventDispatcher dispatcher = this.internalWebApplication.getListenerEventDispatcher();
            if (oldValue == null) {
                HttpSessionBindingEvent event = new HttpSessionBindingEvent(this, key, value);
                dispatcher.dispatchHttpSessionAttributeListener_attributeAdded(event);
            } else {
                if (oldValue instanceof HttpSessionBindingListener) {
                    HttpSessionBindingEvent unBoundEvent = new HttpSessionBindingEvent(this, key, oldValue);
                    try {
                        ((HttpSessionBindingListener)oldValue).valueUnbound(unBoundEvent);
                    }
                    catch (Throwable t) {
                        log.error(t.getMessage(), t);
                    }
                }
                HttpSessionBindingEvent event = new HttpSessionBindingEvent(this, key, oldValue);
                dispatcher.dispatchHttpSessionAttributeListener_attributeReplaced(event);
            }
        }
    }

    @Override
    public void putValue(String key, Object value) {
        this.checkInvalidate();
        this.setAttribute(key, value);
    }

    @Override
    public void removeAttribute(String key) {
        this.checkInvalidate();
        Object oldValue = this.attributeMap.remove(key);
        if (oldValue != null) {
            HttpSessionBindingEvent event = new HttpSessionBindingEvent(this, key, oldValue);
            if (oldValue instanceof HttpSessionBindingListener) {
                try {
                    ((HttpSessionBindingListener)oldValue).valueUnbound(event);
                }
                catch (Throwable t) {
                    log.error(t.getMessage(), t);
                }
            }
            ListenerEventDispatcher dispatcher = this.internalWebApplication.getListenerEventDispatcher();
            dispatcher.dispatchHttpSessionAttributeListener_attributeRemoved(event);
        }
    }

    @Override
    public void removeValue(String key) {
        this.checkInvalidate();
        this.removeAttribute(key);
    }

    @Override
    public void invalidate() {
        if (!this.invalidate) {
            this.dispatchDestroyEvent();
            this.invalidate = true;
            this.internalWebApplication = null;
            this.attributeMap.clear();
            this.attributeMap = null;
        }
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    protected void dispatchCreateEvent() {
        if (this.internalWebApplication == null) {
            return;
        }
        HttpSessionEvent event = new HttpSessionEvent(this);
        ListenerEventDispatcher dispatcher = this.internalWebApplication.getListenerEventDispatcher();
        dispatcher.dispatchHttpSessionListener_sessionCreated(event);
    }

    protected void dispatchDestroyEvent() {
        if (this.internalWebApplication == null) {
            return;
        }
        HttpSessionEvent event = new HttpSessionEvent(this);
        ListenerEventDispatcher dispatcher = this.internalWebApplication.getListenerEventDispatcher();
        dispatcher.dispatchHttpSessionListener_sessionDestroyed(event);
    }

    public void setLastAccessedTime(long lastAccessedTime) {
        this.lastAccessedTime = lastAccessedTime;
    }

    public boolean isInvalidate() {
        return this.invalidate;
    }

    private void checkInvalidate() {
        if (this.invalidate) {
            throw new IllegalStateException("Session invalidated.");
        }
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }
}

