/*
 * Decompiled with CFR 0.152.
 */
package sdloader.javaee.impl;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import sdloader.http.HttpConst;
import sdloader.http.HttpHeader;
import sdloader.javaee.impl.ServletOutputStreamImpl;
import sdloader.util.FastByteArrayOutputStream;
import sdloader.util.WebUtil;

public class HttpServletResponseImpl
implements HttpServletResponse {
    private Locale locale = Locale.getDefault();
    private String characterEncoding = "ISO-8859-1";
    private HttpHeader header = new HttpHeader();
    private ServletOutputStreamImpl servletOutputStream = new ServletOutputStreamImpl();
    private ServletOutputStream outputStream;
    private PrintWriter writer;
    private int bufferSize;

    public void addCookie(Cookie cookie) {
        this.header.addCookie(cookie);
    }

    public boolean containsHeader(String name) {
        return this.header.getHeaderValue(name) != null;
    }

    public String getContentType() {
        return this.header.getHeaderValue("Content-Type");
    }

    public void setContentLength(int length) {
        this.header.addHeader("Content-Length", String.valueOf(length));
    }

    public void setContentType(String type) {
        this.header.addHeader("Content-Type", type);
        String encodeInContentType = WebUtil.parseCharsetFromContentType(type);
        if (encodeInContentType != null) {
            this.characterEncoding = encodeInContentType;
        }
    }

    public void setStatus(int sc) {
        this.header.setStatusCode(sc);
        this.header.setStatus(HttpConst.findStatus(sc));
    }

    public void setStatus(int sc, String msg) {
        this.header.setStatus(msg);
        this.header.setStatusCode(sc);
    }

    public String encodeURL(String url) {
        return url;
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    public String encodeUrl(String uri) {
        return uri;
    }

    public String encodeRedirectUrl(String url) {
        return url;
    }

    public void sendError(int error, String message) throws IOException {
        this.setStatus(error, message);
        this.commitOutputStream();
    }

    public void sendError(int error) throws IOException {
        this.setStatus(error);
        this.commitOutputStream();
    }

    public void sendRedirect(String path) throws IOException {
        this.header.addHeader("Location", path);
        this.setStatus(302);
        this.commitOutputStream();
    }

    public void setDateHeader(String name, long time) {
        this.setHeader(name, WebUtil.formatHeaderDate(new Date(time)));
    }

    public void addDateHeader(String name, long time) {
        this.addHeader(name, WebUtil.formatHeaderDate(new Date(time)));
    }

    public void setHeader(String name, String value) {
        this.header.setHeader(name, value);
    }

    public void addHeader(String name, String value) {
        this.header.addHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, String.valueOf(value));
    }

    public void addIntHeader(String name, int value) {
        this.addHeader(name, String.valueOf(value));
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("getOutputStream was called.");
        }
        this.outputStream = this.servletOutputStream;
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.outputStream != null) {
            throw new IllegalStateException("getOutputStream was called.");
        }
        WebUtil.checkSupportedEndcoding(this.characterEncoding);
        if (this.writer == null) {
            this.writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)this.servletOutputStream, this.characterEncoding)));
        }
        return this.writer;
    }

    public void setCharacterEncoding(String encoding) {
        this.characterEncoding = encoding;
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void flushBuffer() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
        this.servletOutputStream.flush();
    }

    public void resetBuffer() {
        this.outputStream = null;
        this.writer = null;
        this.servletOutputStream = new ServletOutputStreamImpl();
    }

    public boolean isCommitted() {
        return this.servletOutputStream.isClosed();
    }

    public void reset() {
        this.servletOutputStream = new ServletOutputStreamImpl();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int getBodySize() throws IOException {
        this.flushBuffer();
        return this.servletOutputStream.getOutputSize();
    }

    public FastByteArrayOutputStream getBodyData() throws IOException {
        this.flushBuffer();
        this.servletOutputStream.close();
        return this.servletOutputStream.getOutputData();
    }

    public HttpHeader getResponseHeader() {
        return this.header;
    }

    protected void commitOutputStream() throws IOException {
        this.servletOutputStream.flush();
        this.servletOutputStream.close();
    }
}

