/*
 * Decompiled with CFR 0.152.
 */
package sdloader.javaee.impl;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.Principal;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestEvent;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import sdloader.http.HttpBody;
import sdloader.http.HttpHeader;
import sdloader.http.HttpRequest;
import sdloader.javaee.InternalWebApplication;
import sdloader.javaee.ListenerEventDispatcher;
import sdloader.javaee.SessionManager;
import sdloader.javaee.impl.ServletContextImpl;
import sdloader.util.CollectionsUtil;
import sdloader.util.IteratorEnumeration;
import sdloader.util.PathUtil;
import sdloader.util.WebUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServletRequestImpl
implements HttpServletRequest {
    private StringBuffer requestURL;
    private String servletPath;
    private String pathInfo;
    private String protocol = "HTTP/1.1";
    private String scheme = "http";
    private int serverPort;
    private int localPort;
    private int remotePort;
    private String remoteAddr;
    private String localAddr;
    private String remoteHost;
    private String localName;
    private String characterEncoding;
    private Locale locale = Locale.getDefault();
    private Map<String, Object> attributeMap = CollectionsUtil.newHashMap();
    private HttpRequest httpRequest;
    private SessionManager sessionManager;
    private InternalWebApplication internalWebApplication;
    private String uriEncoding = "ISO-8859-1";
    private String currentSessionId;

    public HttpServletRequestImpl(HttpRequest httpRequest, InternalWebApplication internalWebApplication, SessionManager sessionManager) {
        this.httpRequest = httpRequest;
        this.internalWebApplication = internalWebApplication;
        this.currentSessionId = this.getRequestedSessionId();
        this.sessionManager = sessionManager;
    }

    @Override
    public String getHeader(String headerName) {
        return this.httpRequest.getHeader().getHeaderValue(headerName);
    }

    @Override
    public Enumeration<String> getHeaders(String headerName) {
        return new IteratorEnumeration<String>(this.httpRequest.getHeader().getHeaderValueList(headerName).iterator());
    }

    @Override
    public Enumeration<String> getHeaderNames() {
        return new IteratorEnumeration<String>(this.httpRequest.getHeader().getHeaderNameList().iterator());
    }

    @Override
    public int getIntHeader(String paramName) {
        String val = this.httpRequest.getHeader().getHeaderValue(paramName);
        if (val != null) {
            return Integer.parseInt(val);
        }
        return -1;
    }

    @Override
    public String getMethod() {
        return this.httpRequest.getHeader().getMethod();
    }

    @Override
    public String getQueryString() {
        return this.httpRequest.getHeader().getQueryString();
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributeMap.get(key);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return new IteratorEnumeration<String>(this.attributeMap.keySet().iterator());
    }

    @Override
    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    @Override
    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        WebUtil.checkSupportedEndcoding(encoding);
        this.httpRequest.getParameters().setBodyEncoding(encoding);
        this.characterEncoding = encoding;
    }

    @Override
    public int getContentLength() {
        String length = this.getHeader("Content-Length");
        if (length == null) {
            return 0;
        }
        return Integer.parseInt(length);
    }

    @Override
    public String getContentType() {
        return this.httpRequest.getHeader().getHeaderValue("Content-Type");
    }

    @Override
    public ServletInputStream getInputStream() throws IOException {
        byte[] data = this.httpRequest.getBody().getBodyData();
        if (data == null) {
            data = new byte[]{};
        }
        final byte[] isData = data;
        ServletInputStream sIs = new ServletInputStream(){
            private InputStream is;
            {
                this.is = new ByteArrayInputStream(isData);
            }

            public int read() throws IOException {
                return this.is.read();
            }
        };
        return sIs;
    }

    @Override
    public String getParameter(String key) {
        return this.httpRequest.getParameters().getParamter(key);
    }

    @Override
    public Enumeration<String> getParameterNames() {
        Iterator<String> paramNameItr = this.httpRequest.getParameters().getParameterNames();
        return new IteratorEnumeration<String>(paramNameItr);
    }

    @Override
    public String[] getParameterValues(String key) {
        return this.httpRequest.getParameters().getParamterValues(key);
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        return this.httpRequest.getParameters().getParamterMap();
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public BufferedReader getReader() throws IOException {
        byte[] data = this.httpRequest.getBody().getBodyData();
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        BufferedReader reader = new BufferedReader(new InputStreamReader(bin));
        return reader;
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("ServletRequest attribute key is null.");
        }
        if (value == null) {
            this.removeAttribute(key);
        } else {
            Object oldValue = this.attributeMap.get(key);
            ListenerEventDispatcher dispatcher = this.internalWebApplication.getListenerEventDispatcher();
            ServletContextImpl sc = this.internalWebApplication.getServletContext();
            if (oldValue == null) {
                this.attributeMap.put(key, value);
                ServletRequestAttributeEvent event = new ServletRequestAttributeEvent(sc, this, key, value);
                dispatcher.dispatchServletRequestAttributeListener_attributeAdded(event);
            } else if (oldValue != value) {
                this.attributeMap.put(key, value);
                ServletRequestAttributeEvent event = new ServletRequestAttributeEvent(sc, this, key, oldValue);
                dispatcher.dispatchServletRequestAttributeListener_attributeReplaced(event);
            }
        }
    }

    @Override
    public void removeAttribute(String key) {
        Object value = this.attributeMap.remove(key);
        if (value != null) {
            ServletContextImpl sc = this.internalWebApplication.getServletContext();
            ServletRequestAttributeEvent event = new ServletRequestAttributeEvent(sc, this, key, value);
            ListenerEventDispatcher dispatcher = this.internalWebApplication.getListenerEventDispatcher();
            dispatcher.dispatchServletRequestAttributeListener_attributeRemoved(event);
        }
    }

    @Override
    public String getContextPath() {
        return this.getServletContextImpl().getServletContextName();
    }

    @Override
    public StringBuffer getRequestURL() {
        if (this.requestURL == null) {
            this.requestURL = WebUtil.buildRequestURL(this.getScheme(), this.getLocalName(), this.getServerPort(), this.getRequestURI());
        }
        return new StringBuffer(this.decodeURI(this.requestURL.toString()));
    }

    @Override
    public Cookie[] getCookies() {
        List<Cookie> cookieList = this.httpRequest.getHeader().getCookieList();
        Cookie[] cookies = cookieList.toArray(new Cookie[0]);
        return cookies;
    }

    @Override
    public HttpSession getSession() {
        return this.getSession(true);
    }

    @Override
    public HttpSession getSession(boolean create) {
        HttpSession session = this.sessionManager.getSession(this.currentSessionId, create, this.internalWebApplication);
        if (session != null) {
            this.currentSessionId = session.getId();
        }
        return session;
    }

    @Override
    public String getRequestedSessionId() {
        Cookie cookie = this.httpRequest.getHeader().getCookie("JSESSIONID");
        return cookie != null ? cookie.getValue() : null;
    }

    @Override
    public String getRequestURI() {
        return this.decodeURI(this.httpRequest.getHeader().getRequestURI());
    }

    @Override
    public String getServletPath() {
        return this.decodeURI(this.servletPath);
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public String getServerName() {
        String host = this.httpRequest.getHeader().getHeaderValue("Host");
        if (host.indexOf(":") > 0) {
            return host.substring(0, host.indexOf(":"));
        }
        return host;
    }

    @Override
    public int getServerPort() {
        return this.serverPort;
    }

    @Override
    public int getLocalPort() {
        return this.localPort;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public int getRemotePort() {
        return this.remotePort;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public Enumeration<Locale> getLocales() {
        Vector vec = CollectionsUtil.newVector();
        Locale[] locales = Locale.getAvailableLocales();
        if (locales != null) {
            for (int i = 0; i < locales.length; ++i) {
                vec.add(locales[i]);
            }
        }
        return vec.elements();
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path) {
        if (!PathUtil.startsWithSlash(path)) {
            String servletAndPathInfo = this.getServletPath();
            if (this.getPathInfo() != null) {
                servletAndPathInfo = servletAndPathInfo + this.getPathInfo();
            }
            path = PathUtil.computeRelativePath(servletAndPathInfo, path);
        }
        return this.getServletContextImpl().getRequestDispatcher(path);
    }

    @Override
    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    @Override
    public String getRemoteHost() {
        return this.remoteHost;
    }

    @Override
    public String getPathInfo() {
        return this.decodeURI(this.pathInfo);
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public String getRealPath(String path) {
        return this.getServletContextImpl().getRealPath(path);
    }

    @Override
    public String getLocalAddr() {
        return this.localAddr;
    }

    @Override
    public String getAuthType() {
        return null;
    }

    @Override
    public long getDateHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1L;
        }
        try {
            return WebUtil.parseHeaderDate(value);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("date format fail.header name=" + name + " value=" + value);
        }
    }

    @Override
    public String getPathTranslated() {
        return null;
    }

    @Override
    public String getRemoteUser() {
        return null;
    }

    @Override
    public boolean isUserInRole(String arg0) {
        return false;
    }

    @Override
    public Principal getUserPrincipal() {
        return null;
    }

    @Override
    public boolean isRequestedSessionIdValid() {
        return true;
    }

    @Override
    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    @Override
    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    @Override
    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public void intoScope() {
        ServletContextImpl sc = this.internalWebApplication.getServletContext();
        ServletRequestEvent event = new ServletRequestEvent(sc, this);
        ListenerEventDispatcher dispatcher = this.internalWebApplication.getListenerEventDispatcher();
        dispatcher.dispatchServletRequestListener_requestInitialized(event);
    }

    public void destroy() {
        if (this.internalWebApplication == null) {
            return;
        }
        ServletContextImpl sc = this.internalWebApplication.getServletContext();
        ServletRequestEvent event = new ServletRequestEvent(sc, this);
        ListenerEventDispatcher dispatcher = this.internalWebApplication.getListenerEventDispatcher();
        dispatcher.dispatchServletRequestListener_requestDestroyed(event);
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public HttpHeader getHeader() {
        return this.httpRequest.getHeader();
    }

    public HttpBody getBody() {
        return this.httpRequest.getBody();
    }

    public void setServerPort(int port) {
        this.serverPort = port;
    }

    public void setLocalPort(int port) {
        this.localPort = port;
    }

    public void setRemotePort(int port) {
        this.remotePort = port;
    }

    public void setLocalAddr(String localAddr) {
        this.localAddr = localAddr;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public void setUriEncoding(String uriEncoding) {
        if (uriEncoding != null) {
            this.uriEncoding = uriEncoding;
        }
    }

    protected ServletContextImpl getServletContextImpl() {
        return this.internalWebApplication.getServletContext();
    }

    protected String decodeURI(String path) {
        if (path == null) {
            return null;
        }
        try {
            return URLDecoder.decode(path, this.uriEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }
}

