/*
 * Decompiled with CFR 0.152.
 */
package sdloader.javaee.classloader;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Vector;
import sdloader.log.SDLoaderLog;
import sdloader.log.SDLoaderLogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppClassLoader
extends URLClassLoader {
    protected SDLoaderLog log = SDLoaderLogFactory.getLog(WebAppClassLoader.class);
    protected String[] ignoreLoadFromWebInfPackagePrefix = new String[]{"java.", "com.sun.", "sun."};
    protected String[] parentLoadFirstPackagePrefix = new String[]{"java.", "javax.", "org.apache.el.", "org.apache.jasper.", "org.apache.juli.", "com.sun.", "sun.", "org.w3c.", "org.xml.sax.", "org.omg.", "org.ietf.jgss"};

    public WebAppClassLoader(URL[] webInfUrls, ClassLoader parent) {
        super(webInfUrls, parent);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            return this.doResolve(c, resolve);
        }
        boolean parentFirst = this.isParentFirst(name);
        if (parentFirst) {
            try {
                c = this.findSystemClass(name);
                if (c != null) {
                    this.log.debug("Class load by system. class=[" + name + "]");
                }
                return this.doResolve(c, resolve);
            }
            catch (ClassNotFoundException e) {
                try {
                    c = this.getParent().loadClass(name);
                    if (c != null) {
                        this.log.debug("Class load by parent. class=[" + name + "]");
                    }
                    return this.doResolve(c, resolve);
                }
                catch (ClassNotFoundException e2) {
                    if (!this.isIgnoreLoadFromWebInfPackagePrefix(name)) {
                        c = this.findClass(name);
                        if (c != null) {
                            this.log.debug("Class load by app[" + this.hashCode() + "]. class=[" + name + "]");
                        }
                        return this.doResolve(c, resolve);
                    }
                }
            }
        } else {
            try {
                if (!this.isIgnoreLoadFromWebInfPackagePrefix(name) && (c = this.findClass(name)) != null) {
                    this.log.debug("Class load by app[" + this.hashCode() + "]. class=[" + name + "]");
                }
                return this.doResolve(c, resolve);
            }
            catch (ClassNotFoundException e) {
                try {
                    c = this.findSystemClass(name);
                    if (c != null) {
                        this.log.debug("Class load by system. class=[" + name + "]");
                    }
                    return this.doResolve(c, resolve);
                }
                catch (ClassNotFoundException e3) {
                    c = this.getParent().loadClass(name);
                    if (c != null) {
                        this.log.debug("Class load by parent. class=[" + name + "]");
                    }
                    return this.doResolve(c, resolve);
                }
            }
        }
        throw new ClassNotFoundException("Class not found.class=[" + name + "]");
    }

    protected Class<?> doResolve(Class<?> c, boolean resolve) {
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    protected boolean isParentFirst(String name) {
        if (this.parentLoadFirstPackagePrefix != null) {
            for (int i = 0; i < this.parentLoadFirstPackagePrefix.length; ++i) {
                if (!name.startsWith(this.parentLoadFirstPackagePrefix[i])) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isIgnoreLoadFromWebInfPackagePrefix(String name) {
        if (this.ignoreLoadFromWebInfPackagePrefix != null) {
            for (int i = 0; i < this.ignoreLoadFromWebInfPackagePrefix.length; ++i) {
                if (!name.startsWith(this.ignoreLoadFromWebInfPackagePrefix[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> resources = super.getResources(name);
        Vector<URL> margeUrlList = new Vector<URL>();
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            if (margeUrlList.contains(url)) continue;
            margeUrlList.add(url);
        }
        return margeUrlList.elements();
    }
}

