/*
 * Decompiled with CFR 0.152.
 */
package sdloader.javaee.classloader;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sdloader.internal.resource.ArchiveTypeResource;
import sdloader.internal.resource.BranchTypeResource;
import sdloader.internal.resource.Resource;
import sdloader.javaee.classloader.WebAppClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryWebAppClassLoader
extends WebAppClassLoader {
    private Map<URL, Resource> resources;

    public InMemoryWebAppClassLoader(Map<URL, Resource> resources, URL[] classPathURLs, ClassLoader parent) {
        super(classPathURLs, parent);
        this.resources = resources;
    }

    @Override
    public URL getResource(String name) {
        Resource res = this.findClassPathResource(name);
        return res != null ? res.getURL() : null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        List<Resource> resourceList = this.findClassPathResources(name, false);
        final Iterator<Resource> itr = resourceList.iterator();
        return new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return itr.hasNext();
            }

            @Override
            public URL nextElement() {
                Resource res = (Resource)itr.next();
                return res.getURL();
            }
        };
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String classResourceName = name.replace(".", "/") + ".class";
        Resource classResource = this.findClassPathResource(classResourceName);
        if (classResource != null) {
            byte[] bytes = classResource.getResourceAsBytes();
            Class<?> c = this.defineClass(name, bytes, 0, bytes.length);
            return c;
        }
        throw new ClassNotFoundException(name);
    }

    public Map<URL, Resource> getResources() {
        return this.resources;
    }

    protected Resource findClassPathResource(String name) {
        List<Resource> resourceList = this.findClassPathResources(name, true);
        return resourceList.size() == 0 ? null : resourceList.get(0);
    }

    protected List<Resource> findClassPathResources(String name, boolean firstOnly) {
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        URL[] classPathURLs = this.getURLs();
        for (int i = 0; i < classPathURLs.length; ++i) {
            Resource classPathResource;
            URL classPathBase = classPathURLs[i];
            Resource classPathBaseResource = this.resources.get(classPathBase);
            if (classPathBaseResource instanceof BranchTypeResource) {
                try {
                    URL resourceUrl = new URL(classPathBase.toExternalForm() + name);
                    Resource classPathResource2 = this.resources.get(resourceUrl);
                    if (classPathResource2 == null) continue;
                    resourceList.add(classPathResource2);
                }
                catch (Exception e) {}
                continue;
            }
            if (!(classPathBaseResource instanceof ArchiveTypeResource) || (classPathResource = ((ArchiveTypeResource)classPathBaseResource).getArchiveResource(name)) == null) continue;
            resourceList.add(classPathResource);
        }
        return resourceList;
    }
}

