/*
 * Decompiled with CFR 0.152.
 */
package sdloader.javaee;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContextEvent;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import sdloader.internal.SDLoaderConfig;
import sdloader.internal.resource.ArchiveTypeResource;
import sdloader.internal.resource.BranchTypeResource;
import sdloader.internal.resource.LeafTypeResource;
import sdloader.internal.resource.Resource;
import sdloader.internal.resource.ResourceBuilderImpl;
import sdloader.internal.resource.ResourceURLConnection;
import sdloader.javaee.InternalWebApplication;
import sdloader.javaee.WebAppContext;
import sdloader.javaee.WebAppContextXmlParserHandler;
import sdloader.javaee.classloader.InMemoryWebAppClassLoader;
import sdloader.javaee.classloader.WebAppClassLoader;
import sdloader.javaee.jasper.InMemoryEmbeddedServletOptions;
import sdloader.javaee.servlet.CommandServlet;
import sdloader.javaee.servlet.WebAppListServlet;
import sdloader.javaee.webxml.InitParamTag;
import sdloader.javaee.webxml.ServletMappingTag;
import sdloader.javaee.webxml.ServletTag;
import sdloader.javaee.webxml.WebAppTag;
import sdloader.javaee.webxml.WebXml;
import sdloader.javaee.webxml.WebXmlBuilder;
import sdloader.log.SDLoaderLog;
import sdloader.log.SDLoaderLogFactory;
import sdloader.util.Assertion;
import sdloader.util.ClassUtil;
import sdloader.util.CollectionsUtil;
import sdloader.util.IOUtil;
import sdloader.util.MessageDigestUtil;
import sdloader.util.PathUtil;
import sdloader.util.ResourceUtil;
import sdloader.util.WarUtil;
import sdloader.util.WebUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppManager {
    private static SDLoaderLog log = SDLoaderLogFactory.getLog(WebAppManager.class);
    protected String webappDirPath;
    protected List<WebAppContext> webAppContextList = CollectionsUtil.newArrayList();
    protected List<InternalWebApplication> webAppList = CollectionsUtil.newArrayList();
    protected boolean isInmemoryExtract = false;
    protected Map<URL, Map<URL, Resource>> warInmemoryMap = CollectionsUtil.newHashMap();
    private static final String JASPER_SERVLET_CLASS = "org.apache.jasper.servlet.JspServlet";
    private static final boolean JASPER_SUPPORT = ClassUtil.hasClass("org.apache.jasper.servlet.JspServlet");
    private boolean initialized;
    private SDLoaderConfig config;

    public void init(SDLoaderConfig config) {
        this.config = config;
        try {
            this.initConfig();
            if (this.webAppContextList.size() == 0) {
                this.detectWebApps();
            }
            this.initWebAppContext();
            this.initialized = true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void initConfig() {
        this.isInmemoryExtract = this.config.getConfigBoolean("sdloader.warInMemoryExtract");
    }

    protected void detectWebApps() throws Exception {
        int i;
        this.webappDirPath = this.config.getConfigString("sdloader.webAppPath");
        File webappDir = new File(this.webappDirPath);
        if (!webappDir.exists()) {
            log.info("webapps directory not exists.path=" + this.webappDirPath);
            return;
        }
        File[] dirs = webappDir.listFiles(IOUtil.IGNORE_DIR_FILEFILTER);
        File[] warFiles = webappDir.listFiles(IOUtil.WAR_FILEFILETR);
        if (!this.isInmemoryExtract && warFiles != null) {
            for (i = 0; i < warFiles.length; ++i) {
                WarUtil.extractWar(warFiles[i], new File(webappDir, WarUtil.getArchiveName(warFiles[i].getName())));
            }
        }
        dirs = webappDir.listFiles(IOUtil.IGNORE_DIR_FILEFILTER);
        if (!this.isInmemoryExtract) {
            if (dirs != null) {
                for (i = 0; i < dirs.length; ++i) {
                    String contextPath = "/" + dirs[i].getName();
                    String docBase = this.webappDirPath + contextPath;
                    WebAppContext context = new WebAppContext(contextPath, PathUtil.file2URL(docBase));
                    this.addWebAppContext(context);
                    log.info("detect webapp context. contextPath=" + contextPath + " docBase=" + docBase);
                }
            }
        } else {
            URL.setURLStreamHandlerFactory(new ArchiveURLStreamHandlerFactory());
            ResourceBuilderImpl builder = new ResourceBuilderImpl();
            for (File warfile : warFiles) {
                URL warDocRoot = ResourceUtil.createURL("war:" + warfile.toURI().toURL().toExternalForm());
                String contextPath = "/" + ResourceUtil.stripExtension(warfile.getName());
                Map<URL, Resource> map = builder.build(warfile.getPath());
                WebAppContext context = new WebAppContext(contextPath, warDocRoot);
                this.addWebAppContext(context);
                this.warInmemoryMap.put(warDocRoot, map);
            }
        }
        File[] contextXMLs = webappDir.listFiles(IOUtil.XML_FILEFILTER);
        this.parseContextXMLs(contextXMLs);
    }

    protected void initWebAppContext() throws Exception {
        if (this.webAppContextList.size() == 0) {
            throw new RuntimeException("There are no Web Application.");
        }
        for (WebAppContext context : this.webAppContextList) {
            this.initWebAppContext0(context);
        }
        this.webAppList.add(this.getRootWebApplication());
        this.webAppList.add(this.getCommandWebApplication());
        Collections.sort(this.webAppList, new Comparator<InternalWebApplication>(){

            @Override
            public int compare(InternalWebApplication o1, InternalWebApplication o2) {
                return o2.getContextPath().compareTo(o1.getContextPath());
            }
        });
    }

    protected void initWebAppContext0(WebAppContext context) throws Exception {
        String contextPath = context.getContextPath();
        log.info("create webapp [" + contextPath + "]");
        URL[] docBase = context.getDocBase();
        for (int i = docBase.length - 1; i >= 0; --i) {
            URL url = docBase[i];
            File file = PathUtil.url2File(url);
            if (!file.exists() || !file.isFile() || !file.getName().endsWith(".war")) continue;
            File extractDir = new File(this.generateWorkDirPath("war", contextPath + "_" + file.getName()));
            WarUtil.extractWar(file, extractDir);
            docBase[i] = PathUtil.file2URL(extractDir);
        }
        context.setDocBase(docBase);
        WebXml webxml = context.getWebXml();
        if (webxml == null) {
            webxml = this.buildWebXml(docBase);
        }
        this.setDefaultServlet(webxml, docBase, contextPath, this.isInmemoryExtract);
        ClassLoader webAppClassLoader = !this.isInmemoryExtract ? this.createWebAppClassLoader(docBase) : this.createInMemoryWebAppClassLoader(docBase[0]);
        context.setWebXml(webxml);
        InternalWebApplication webapp = new InternalWebApplication(context, webAppClassLoader, this);
        this.webAppList.add(webapp);
        log.info("create success.");
    }

    protected WebXml buildWebXml(URL[] url) throws SAXException, ParserConfigurationException, IOException, MalformedURLException {
        for (int i = 0; i < url.length; ++i) {
            URL webXmlUrl = ResourceUtil.createURL(url[i], "WEB-INF/web.xml");
            if (!ResourceUtil.isResourceExist(webXmlUrl)) continue;
            log.info("web.xml load start. Path=" + webXmlUrl);
            WebXml webXml = WebXmlBuilder.build(webXmlUrl);
            log.info("web.xml load success.");
            return webXml;
        }
        log.warn("web.xml not detected. use default web.xml.");
        WebXml webxml = new WebXml();
        return webxml;
    }

    protected InternalWebApplication getRootWebApplication() {
        String webAppListServletName = "webAppList";
        ServletTag webAppListServletTag = new ServletTag();
        webAppListServletTag.setLoadOnStartup(0);
        webAppListServletTag.setServletClass(WebAppListServlet.class.getName());
        webAppListServletTag.setServletName("webAppList");
        ServletMappingTag webAppListMappingTag = new ServletMappingTag();
        webAppListMappingTag.setServletName("webAppList");
        webAppListMappingTag.setUrlPattern("/");
        WebXml webXmlTag = new WebXml();
        WebAppTag webAppTag = webXmlTag.getWebApp();
        webAppTag.addServlet(webAppListServletTag);
        webAppTag.addServletMapping(webAppListMappingTag);
        webXmlTag.setWebApp(webAppTag);
        String contextPath = "/";
        URL docBase = PathUtil.file2URL(this.webappDirPath + "/" + "ROOT");
        if (ResourceUtil.isResourceExist(docBase)) {
            this.setDefaultServlet(webXmlTag, new URL[]{docBase}, contextPath, false);
        }
        ClassLoader webAppClassLoader = this.createWebAppClassLoader(new URL[]{docBase});
        WebAppContext context = new WebAppContext(contextPath, docBase);
        context.setWebXml(webXmlTag);
        InternalWebApplication webapp = new InternalWebApplication(context, webAppClassLoader, this);
        return webapp;
    }

    private InternalWebApplication getCommandWebApplication() {
        String contextPath = "/sdloader-command";
        URL docBase = PathUtil.file2URL(this.webappDirPath + "/sdloader-control");
        WebXml webXmlTag = new WebXml();
        webXmlTag.getWebApp().addServlet(new ServletTag().setServletName("sdloader-command").setServletClass(CommandServlet.class));
        webXmlTag.getWebApp().addServletMapping(new ServletMappingTag().setServletName("sdloader-command").setUrlPattern("/*"));
        ClassLoader webAppClassLoader = this.createWebAppClassLoader(new URL[]{docBase});
        WebAppContext context = new WebAppContext(contextPath, docBase);
        context.setWebXml(webXmlTag);
        InternalWebApplication webapp = new InternalWebApplication(context, webAppClassLoader, this);
        return webapp;
    }

    protected ClassLoader createWebAppClassLoader(URL[] docBase) {
        ArrayList<URL> urlList = CollectionsUtil.newArrayList();
        for (int i = 0; i < docBase.length; ++i) {
            File webinfLibDir;
            URL[] libs;
            File docBaseDir = PathUtil.url2File(docBase[i]);
            File classesDir = new File(docBaseDir, "/WEB-INF/classes/");
            if (classesDir.exists()) {
                urlList.add(PathUtil.file2URL(classesDir));
            }
            if ((libs = WebUtil.createClassPaths(webinfLibDir = new File(docBaseDir, "/WEB-INF/lib"), IOUtil.JAR_ZIP_FILEFILTER, false)) == null) continue;
            for (int j = 0; j < libs.length; ++j) {
                urlList.add(libs[j]);
            }
        }
        URL[] urls = urlList.toArray(new URL[0]);
        ClassLoader parentClassLoader = Thread.currentThread().getContextClassLoader();
        WebAppClassLoader webAppClassLoader = new WebAppClassLoader(urls, parentClassLoader);
        return webAppClassLoader;
    }

    protected ClassLoader createInMemoryWebAppClassLoader(URL docBase) {
        BranchTypeResource dirResource;
        List<Resource> libs;
        URL webinfLibDir;
        Resource libDirResource;
        URL classesDir;
        ArrayList<URL> urlList = CollectionsUtil.newArrayList();
        Map<URL, Resource> resourceMap = this.warInmemoryMap.get(docBase);
        if (resourceMap.get(classesDir = ResourceUtil.createURL(docBase, "WEB-INF/classes/")) != null) {
            urlList.add(classesDir);
        }
        if ((libDirResource = resourceMap.get(webinfLibDir = ResourceUtil.createURL(docBase, "WEB-INF/lib/"))) != null && (libs = (dirResource = (BranchTypeResource)libDirResource).getResources()) != null) {
            for (Resource lib : libs) {
                String path = lib.getPath();
                if (!(lib instanceof LeafTypeResource) || !path.endsWith(".jar") && !path.endsWith(".zip")) continue;
                urlList.add(lib.getURL());
            }
        }
        URL[] urls = urlList.toArray(new URL[0]);
        ClassLoader parentClassLoader = Thread.currentThread().getContextClassLoader();
        InMemoryWebAppClassLoader webAppClassLoader = new InMemoryWebAppClassLoader(resourceMap, urls, parentClassLoader);
        return webAppClassLoader;
    }

    private void setDefaultServlet(WebXml webXml, URL[] docBase, String contextPath, boolean warInMemory) {
        String jspServletName = "jsp";
        if (JASPER_SUPPORT && webXml.getWebApp().findServlet("jsp") == null) {
            log.debug("set default jsp servlet.");
            ServletTag jspServlet = new ServletTag();
            jspServlet.setLoadOnStartup(0);
            jspServlet.setServletClass(JASPER_SERVLET_CLASS);
            jspServlet.setServletName("jsp");
            jspServlet.addInitParam(new InitParamTag("logVerbosityLevel", "WARNING"));
            jspServlet.addInitParam(new InitParamTag("validating", "false"));
            jspServlet.addInitParam(new InitParamTag("fork", "false"));
            if (this.isInmemoryExtract) {
                jspServlet.addInitParam(new InitParamTag("engineOptionsClass", InMemoryEmbeddedServletOptions.class.getName()));
            }
            String jspWorkDirPath = this.generateWorkDirPath("jsp", contextPath);
            File jspWorkDir = new File(jspWorkDirPath);
            jspWorkDir.mkdirs();
            jspServlet.addInitParam(new InitParamTag("scratchdir", jspWorkDirPath));
            String jspLibPath = this.config.getConfigStringIgnoreExist("sdloader.jsp.libpath");
            if (jspLibPath != null) {
                jspLibPath = PathUtil.replaceFileSeparator(jspLibPath);
                jspServlet.addInitParam(new InitParamTag("classpath", jspLibPath));
            }
            ServletMappingTag jspMapping = new ServletMappingTag();
            jspMapping.setServletName("jsp");
            jspMapping.setUrlPattern("*.jsp");
            webXml.getWebApp().addServlet(jspServlet);
            webXml.getWebApp().addServletMapping(jspMapping);
        }
        String fileSavingServletName = "default";
        if (webXml.getWebApp().findServlet("default") == null) {
            log.debug("set default file savings servlet.");
            ServletTag fileServletTag = new ServletTag();
            fileServletTag.setLoadOnStartup(0);
            if (warInMemory) {
                fileServletTag.setServletClass("sdloader.javaee.servlet.InMemoryFileSavingServlet");
            } else {
                fileServletTag.setServletClass("sdloader.javaee.servlet.FileSavingServlet");
            }
            fileServletTag.setServletName("default");
            String docRoots = "";
            for (int i = 0; i < docBase.length; ++i) {
                if (i != 0) {
                    docRoots = docRoots + ",";
                }
                docRoots = docRoots + docBase[i].toExternalForm();
            }
            fileServletTag.addInitParam(new InitParamTag("docRootPath", docRoots));
            boolean noCacheMode = this.config.getConfigBoolean("sdloader.response.useNoCacheMode", false);
            if (noCacheMode) {
                fileServletTag.addInitParam(new InitParamTag("ignoreLastModified", "true"));
            }
            ServletMappingTag mappingTag = new ServletMappingTag();
            mappingTag.setServletName("default");
            mappingTag.setUrlPattern("/*");
            webXml.getWebApp().addServlet(fileServletTag);
            webXml.getWebApp().addServletMapping(mappingTag);
        }
    }

    protected String generateWorkDirPath(String functionName, String contextPath) {
        String genDir = MessageDigestUtil.digest(System.getProperty("java.class.path"));
        String workRoot = this.config.getConfigString("sdloader.workDir");
        workRoot = PathUtil.replaceFileSeparator(workRoot);
        String workDirPath = PathUtil.jointPathWithSlash(workRoot, genDir);
        workDirPath = PathUtil.jointPathWithSlash(workDirPath, functionName);
        workDirPath = PathUtil.jointPathWithSlash(workDirPath, contextPath);
        return workDirPath;
    }

    protected void parseContextXMLs(File[] contextXMLs) throws Exception {
        if (contextXMLs != null) {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            for (int i = 0; i < contextXMLs.length; ++i) {
                File contextXml = contextXMLs[i];
                String fileName = contextXml.getName();
                WebAppContextXmlParserHandler contextXmlParserHandler = new WebAppContextXmlParserHandler(fileName, this.webappDirPath);
                parser.parse(contextXml, (DefaultHandler)contextXmlParserHandler);
                this.addWebAppContext(Assertion.notNull(contextXmlParserHandler.getWebAppContext()));
            }
        }
    }

    public List<String> getContextPathList() {
        ArrayList<String> contextPathList = CollectionsUtil.newArrayList();
        for (WebAppContext context : this.webAppContextList) {
            contextPathList.add(context.getContextPath());
        }
        return contextPathList;
    }

    public List<InternalWebApplication> getWebAppList() {
        return this.webAppList;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void addWebAppContext(WebAppContext context) {
        this.webAppContextList.add(context);
    }

    public InternalWebApplication findWebApp(String requestURI) {
        InternalWebApplication app = this.findWebApp0(requestURI);
        if (app == null) {
            app = this.findWebApp0("/");
        }
        return app;
    }

    protected InternalWebApplication findWebApp0(String requestURI) {
        for (InternalWebApplication webapp : this.getWebAppList()) {
            String contextStripPath;
            String contextPath = webapp.getContextPath();
            if (requestURI.equals(contextPath)) {
                return webapp;
            }
            if (!requestURI.startsWith(contextPath) || !(contextStripPath = requestURI.substring(contextPath.length())).startsWith("/")) continue;
            return webapp;
        }
        return null;
    }

    public void close() {
        List<InternalWebApplication> webAppList = this.getWebAppList();
        for (InternalWebApplication webapp : webAppList) {
            List<Filter> filterList;
            List<Servlet> servletList = webapp.getServletList();
            if (servletList != null) {
                for (Servlet servlet : servletList) {
                    try {
                        servlet.destroy();
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), e);
                    }
                }
            }
            if ((filterList = webapp.getFilterList()) != null) {
                for (Filter filter : filterList) {
                    try {
                        filter.destroy();
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), e);
                    }
                }
            }
            ServletContextEvent contextEvent = new ServletContextEvent(webapp.getServletContext());
            webapp.getListenerEventDispatcher().dispatchServletContextListener_contextDestroyed(contextEvent);
        }
    }

    private final class InnerJarURLStreamHandler
    extends URLStreamHandler {
        public static final String PROTOCOL = "innerjar";

        private InnerJarURLStreamHandler() {
        }

        protected URLConnection openConnection(URL u) throws IOException {
            ArchiveTypeResource jar;
            Resource innerJarResource;
            String warPath = u.getPath();
            warPath = warPath.substring(0, warPath.indexOf("!"));
            Map<URL, Resource> resources = null;
            for (URL key : WebAppManager.this.warInmemoryMap.keySet()) {
                if (!key.toExternalForm().equals(warPath)) continue;
                resources = WebAppManager.this.warInmemoryMap.get(key);
                break;
            }
            if (resources == null) {
                return new ResourceURLConnection(null);
            }
            String jarPath = u.toExternalForm();
            String innerJar = jarPath.substring(0, jarPath.lastIndexOf("!"));
            String resourceName = jarPath.substring(jarPath.lastIndexOf("!/") + 2, jarPath.length());
            Resource jarResource = resources.get(ResourceUtil.createURL(innerJar));
            if (jarResource != null && (innerJarResource = (jar = (ArchiveTypeResource)jarResource).getArchiveResource(resourceName)) != null) {
                return new ResourceURLConnection(innerJarResource);
            }
            return new ResourceURLConnection(null);
        }
    }

    private final class WarURLStreamHandler
    extends URLStreamHandler {
        public static final String PROTOCOL = "war";

        private WarURLStreamHandler() {
        }

        protected URLConnection openConnection(URL u) throws IOException {
            String warPath = u.toExternalForm();
            warPath = warPath.substring(0, warPath.indexOf("!"));
            Map<URL, Resource> resources = null;
            for (URL key : WebAppManager.this.warInmemoryMap.keySet()) {
                if (!key.toExternalForm().equals(warPath)) continue;
                resources = WebAppManager.this.warInmemoryMap.get(key);
                break;
            }
            Resource resource = resources != null ? (Resource)resources.get(u) : null;
            return new ResourceURLConnection(resource);
        }
    }

    private final class ArchiveURLStreamHandlerFactory
    implements URLStreamHandlerFactory {
        private ArchiveURLStreamHandlerFactory() {
        }

        public URLStreamHandler createURLStreamHandler(String protocol) {
            if (protocol.equals("war")) {
                return new WarURLStreamHandler();
            }
            if (protocol.equals("innerjar")) {
                return new InnerJarURLStreamHandler();
            }
            return null;
        }
    }
}

