/*
 * Decompiled with CFR 0.152.
 */
package sdloader.javaee;

import java.io.File;
import java.net.URL;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import sdloader.javaee.WebAppContext;
import sdloader.log.SDLoaderLog;
import sdloader.log.SDLoaderLogFactory;
import sdloader.util.PathUtil;
import sdloader.util.TextFormatUtil;

public class WebAppContextXmlParserHandler
extends DefaultHandler {
    private static SDLoaderLog log = SDLoaderLogFactory.getLog(WebAppContextXmlParserHandler.class);
    private String fileName;
    private String webAppDirPath;
    private WebAppContext webAppContext;

    public WebAppContextXmlParserHandler(String fileName, String webAppDirPath) {
        this.fileName = fileName;
        this.webAppDirPath = webAppDirPath;
    }

    public WebAppContext getWebAppContext() {
        return this.webAppContext;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("Context")) {
            this.processContextTag(attributes);
        }
    }

    protected void processContextTag(Attributes attributes) {
        String contextPath = attributes.getValue("path");
        String docBase = attributes.getValue("docBase");
        if (docBase == null) {
            String message = "docBase attribute not found. file=" + this.fileName;
            log.error(message);
            throw new RuntimeException(message);
        }
        if (contextPath == null) {
            contextPath = this.contextPathFromFileName();
        }
        contextPath = TextFormatUtil.formatTextBySystemProperties(contextPath);
        docBase = TextFormatUtil.formatTextBySystemProperties(docBase);
        String[] bases = docBase.replace('\\', '/').split(",");
        URL[] baseURLs = new URL[bases.length];
        for (int i = 0; i < bases.length; ++i) {
            File baseDir;
            String base = bases[i];
            if (base.startsWith(".")) {
                base = this.webAppDirPath + "/" + base;
            }
            if (!(baseDir = new File(base)).exists()) {
                String message = "docBase not exist. file=" + this.fileName + " contextPath=" + contextPath + " docBase=" + base;
                log.error(message);
                throw new RuntimeException(message);
            }
            if (baseDir.isFile()) {
                String message = "docBase is File path. file=" + this.fileName + " contextPath=" + contextPath + " docBase=" + base;
                log.error(message);
                throw new RuntimeException(message);
            }
            baseURLs[i] = PathUtil.file2URL(base);
        }
        log.info("detect webapp context. contextPath=" + contextPath + " docBase=" + docBase);
        this.webAppContext = new WebAppContext(contextPath, baseURLs);
    }

    protected String contextPathFromFileName() {
        return "/" + this.fileName.substring(0, this.fileName.length() - ".xml".length());
    }
}

