/*
 * Decompiled with CFR 0.152.
 */
package sdloader.javaee;

import java.io.File;
import java.net.URL;
import sdloader.javaee.webxml.WebXml;
import sdloader.util.Assertion;
import sdloader.util.PathUtil;

public class WebAppContext {
    private URL[] docBase;
    private String contextPath;
    private WebXml webXml;

    public WebAppContext(String contextPath, String ... docBaseDirOrWarFile) {
        this.setContextPath(contextPath);
        this.setDocBase(docBaseDirOrWarFile);
    }

    public WebAppContext(String contextPath, File ... docBaseDirOrWarFile) {
        this.setContextPath(contextPath);
        this.setDocBase(docBaseDirOrWarFile);
    }

    public WebAppContext(String contextPath, URL ... docBaseDirOrWarFile) {
        this.setContextPath(contextPath);
        this.setDocBase(docBaseDirOrWarFile);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        Assertion.notNull(contextPath);
        this.contextPath = PathUtil.appendStartSlashIfNeed(contextPath);
    }

    public void setDocBase(String ... docBaseDirOrWarFile) {
        Assertion.notNull(docBaseDirOrWarFile);
        this.docBase = new URL[docBaseDirOrWarFile.length];
        for (int i = 0; i < docBaseDirOrWarFile.length; ++i) {
            this.docBase[i] = PathUtil.file2URL(docBaseDirOrWarFile[i]);
        }
    }

    public void setDocBase(File ... docBaseDirOrWarFile) {
        Assertion.notNull(docBaseDirOrWarFile);
        this.docBase = new URL[docBaseDirOrWarFile.length];
        for (int i = 0; i < docBaseDirOrWarFile.length; ++i) {
            this.docBase[i] = PathUtil.file2URL(docBaseDirOrWarFile[i]);
        }
    }

    public void setDocBase(URL ... docBaseDirOrWarFile) {
        this.docBase = Assertion.notNull(docBaseDirOrWarFile);
    }

    public URL[] getDocBase() {
        return this.docBase;
    }

    public void setWebXml(WebXml webXml) {
        this.webXml = webXml;
    }

    public WebXml getWebXml() {
        return this.webXml;
    }
}

