/*
 * Decompiled with CFR 0.152.
 */
package sdloader.javaee;

import java.util.List;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import sdloader.log.SDLoaderLog;
import sdloader.log.SDLoaderLogFactory;
import sdloader.util.CollectionsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerEventDispatcher {
    private static final SDLoaderLog log = SDLoaderLogFactory.getLog(ListenerEventDispatcher.class);
    private List<ServletContextListener> servletContextListenerList;
    private List<ServletContextAttributeListener> servletContextAttributeListenerList;
    private List<HttpSessionActivationListener> httpSessionActivationListenerList;
    private List<HttpSessionAttributeListener> httpSessionAttributeListenerList;
    private List<HttpSessionListener> httpSessionListenerList;
    private List<ServletRequestListener> servletRequestListenerList;
    private List<ServletRequestAttributeListener> servletRequestAttributeListenerList;

    public void addListener(Object listener) {
        if (listener instanceof ServletContextListener) {
            this.addServletContextListener((ServletContextListener)listener);
        }
        if (listener instanceof ServletContextAttributeListener) {
            this.addServletContextAttributeListener((ServletContextAttributeListener)listener);
        }
        if (listener instanceof HttpSessionActivationListener) {
            this.addHttpSessionActivationListener((HttpSessionActivationListener)listener);
        }
        if (listener instanceof HttpSessionAttributeListener) {
            this.addHttpSessionAttributeListener((HttpSessionAttributeListener)listener);
        }
        if (listener instanceof HttpSessionListener) {
            this.addHttpSessionListener((HttpSessionListener)listener);
        }
        if (listener instanceof ServletRequestListener) {
            this.addServletRequestListener((ServletRequestListener)listener);
        }
        if (listener instanceof ServletRequestAttributeListener) {
            this.addServletRequestAttributeListener((ServletRequestAttributeListener)listener);
        }
    }

    public List<ServletRequestListener> getServletRequestListener() {
        return this.servletRequestListenerList;
    }

    public void addServletRequestListener(ServletRequestListener listener) {
        if (this.servletRequestListenerList == null) {
            this.servletRequestListenerList = CollectionsUtil.newArrayList();
        }
        this.servletRequestListenerList.add(listener);
    }

    public void dispatchServletRequestListener_requestInitialized(ServletRequestEvent event) {
        if (this.servletRequestListenerList != null) {
            for (ServletRequestListener listener : this.servletRequestListenerList) {
                try {
                    listener.requestInitialized(event);
                }
                catch (Throwable t) {
                    log.error(t.getMessage(), t);
                }
            }
        }
    }

    public void dispatchServletRequestListener_requestDestroyed(ServletRequestEvent event) {
        if (this.servletRequestListenerList != null) {
            for (ServletRequestListener listener : this.servletRequestListenerList) {
                try {
                    listener.requestDestroyed(event);
                }
                catch (Throwable t) {
                    log.error(t.getMessage(), t);
                }
            }
        }
    }

    public List<ServletRequestAttributeListener> getServletRequestAttributeListenerList() {
        return this.servletRequestAttributeListenerList;
    }

    public void addServletRequestAttributeListener(ServletRequestAttributeListener listener) {
        if (this.servletRequestAttributeListenerList == null) {
            this.servletRequestAttributeListenerList = CollectionsUtil.newArrayList();
        }
        this.servletRequestAttributeListenerList.add(listener);
    }

    public void dispatchServletRequestAttributeListener_attributeAdded(ServletRequestAttributeEvent event) {
        if (this.servletRequestAttributeListenerList != null) {
            for (ServletRequestAttributeListener listener : this.servletRequestAttributeListenerList) {
                try {
                    listener.attributeAdded(event);
                }
                catch (Throwable t) {
                    log.error(t.getMessage(), t);
                }
            }
        }
    }

    public void dispatchServletRequestAttributeListener_attributeRemoved(ServletRequestAttributeEvent event) {
        if (this.servletRequestAttributeListenerList != null) {
            for (ServletRequestAttributeListener listener : this.servletRequestAttributeListenerList) {
                try {
                    listener.attributeRemoved(event);
                }
                catch (Throwable t) {
                    log.error(t.getMessage(), t);
                }
            }
        }
    }

    public void dispatchServletRequestAttributeListener_attributeReplaced(ServletRequestAttributeEvent event) {
        if (this.servletRequestAttributeListenerList != null) {
            for (ServletRequestAttributeListener listener : this.servletRequestAttributeListenerList) {
                try {
                    listener.attributeReplaced(event);
                }
                catch (Throwable t) {
                    log.error(t.getMessage(), t);
                }
            }
        }
    }

    public List<HttpSessionActivationListener> getHttpSessionActivationListenerList() {
        return this.httpSessionActivationListenerList;
    }

    public void addHttpSessionActivationListener(HttpSessionActivationListener listener) {
        if (this.httpSessionActivationListenerList == null) {
            this.httpSessionActivationListenerList = CollectionsUtil.newArrayList();
        }
        this.httpSessionActivationListenerList.add(listener);
    }

    public void dispatchHttpSessionActivationListener_sessionDidActivate(HttpSessionEvent event) {
        if (this.httpSessionActivationListenerList != null) {
            for (HttpSessionActivationListener listener : this.httpSessionActivationListenerList) {
                listener.sessionDidActivate(event);
            }
        }
    }

    public void dispatchHttpSessionActivationListener_sessionWillPassivate(HttpSessionEvent event) {
        if (this.httpSessionActivationListenerList != null) {
            for (HttpSessionActivationListener listener : this.httpSessionActivationListenerList) {
                listener.sessionWillPassivate(event);
            }
        }
    }

    public List<HttpSessionAttributeListener> getHttpSessionAttributeListenerList() {
        return this.httpSessionAttributeListenerList;
    }

    public void addHttpSessionAttributeListener(HttpSessionAttributeListener listener) {
        if (this.httpSessionAttributeListenerList == null) {
            this.httpSessionAttributeListenerList = CollectionsUtil.newArrayList();
        }
        this.httpSessionAttributeListenerList.add(listener);
    }

    public void dispatchHttpSessionAttributeListener_attributeAdded(HttpSessionBindingEvent event) {
        if (this.httpSessionAttributeListenerList != null) {
            for (HttpSessionAttributeListener listener : this.httpSessionAttributeListenerList) {
                try {
                    listener.attributeAdded(event);
                }
                catch (Throwable t) {
                    log.error(t.getMessage(), t);
                }
            }
        }
    }

    public void dispatchHttpSessionAttributeListener_attributeRemoved(HttpSessionBindingEvent event) {
        if (this.httpSessionAttributeListenerList != null) {
            for (HttpSessionAttributeListener listener : this.httpSessionAttributeListenerList) {
                try {
                    listener.attributeRemoved(event);
                }
                catch (Throwable t) {
                    log.error(t.getMessage(), t);
                }
            }
        }
    }

    public void dispatchHttpSessionAttributeListener_attributeReplaced(HttpSessionBindingEvent event) {
        if (this.httpSessionAttributeListenerList != null) {
            for (HttpSessionAttributeListener listener : this.httpSessionAttributeListenerList) {
                try {
                    listener.attributeReplaced(event);
                }
                catch (Throwable t) {
                    log.error(t.getMessage(), t);
                }
            }
        }
    }

    public List<HttpSessionListener> getHttpSessionListenerList() {
        return this.httpSessionListenerList;
    }

    public void addHttpSessionListener(HttpSessionListener listener) {
        if (this.httpSessionListenerList == null) {
            this.httpSessionListenerList = CollectionsUtil.newArrayList();
        }
        this.httpSessionListenerList.add(listener);
    }

    public void dispatchHttpSessionListener_sessionCreated(HttpSessionEvent event) {
        if (this.httpSessionListenerList != null) {
            for (HttpSessionListener listener : this.httpSessionListenerList) {
                try {
                    listener.sessionCreated(event);
                }
                catch (Throwable t) {
                    log.error(t.getMessage(), t);
                }
            }
        }
    }

    public void dispatchHttpSessionListener_sessionDestroyed(HttpSessionEvent event) {
        if (this.httpSessionListenerList != null) {
            for (HttpSessionListener listener : this.httpSessionListenerList) {
                try {
                    listener.sessionDestroyed(event);
                }
                catch (Throwable t) {
                    log.error(t.getMessage(), t);
                }
            }
        }
    }

    public List<ServletContextAttributeListener> getServletContextAttributeListenerList() {
        return this.servletContextAttributeListenerList;
    }

    public void addServletContextAttributeListener(ServletContextAttributeListener listener) {
        if (this.servletContextAttributeListenerList == null) {
            this.servletContextAttributeListenerList = CollectionsUtil.newArrayList();
        }
        this.servletContextAttributeListenerList.add(listener);
    }

    public void dispatchServletContextAttributeListener_attributeAdded(ServletContextAttributeEvent event) {
        if (this.servletContextAttributeListenerList != null) {
            for (ServletContextAttributeListener listener : this.servletContextAttributeListenerList) {
                try {
                    listener.attributeAdded(event);
                }
                catch (Throwable t) {
                    log.error(t.getMessage(), t);
                }
            }
        }
    }

    public void dispatchServletContextAttributeListener_attributeRemoved(ServletContextAttributeEvent event) {
        if (this.servletContextAttributeListenerList != null) {
            for (ServletContextAttributeListener listener : this.servletContextAttributeListenerList) {
                try {
                    listener.attributeRemoved(event);
                }
                catch (Throwable t) {
                    log.error(t.getMessage(), t);
                }
            }
        }
    }

    public void dispatchServletContextAttributeListener_attributeReplaced(ServletContextAttributeEvent event) {
        if (this.servletContextAttributeListenerList != null) {
            for (ServletContextAttributeListener listener : this.servletContextAttributeListenerList) {
                try {
                    listener.attributeReplaced(event);
                }
                catch (Throwable t) {
                    log.error(t.getMessage(), t);
                }
            }
        }
    }

    public List<ServletContextListener> getServletContextListenerList() {
        return this.servletContextListenerList;
    }

    public void addServletContextListener(ServletContextListener listener) {
        if (this.servletContextListenerList == null) {
            this.servletContextListenerList = CollectionsUtil.newArrayList();
        }
        this.servletContextListenerList.add(listener);
    }

    public void dispatchServletContextListener_contextInitialized(ServletContextEvent event) {
        if (this.servletContextListenerList != null) {
            for (ServletContextListener listener : this.servletContextListenerList) {
                try {
                    listener.contextInitialized(event);
                }
                catch (Throwable t) {
                    log.error(t.getMessage(), t);
                }
            }
        }
    }

    public void dispatchServletContextListener_contextDestroyed(ServletContextEvent event) {
        if (this.servletContextListenerList != null) {
            for (ServletContextListener listener : this.servletContextListenerList) {
                try {
                    listener.contextDestroyed(event);
                }
                catch (Throwable t) {
                    log.error(t.getMessage(), t);
                }
            }
        }
    }
}

