/*
 * Decompiled with CFR 0.152.
 */
package sdloader.javaee;

import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletException;
import sdloader.javaee.ListenerEventDispatcher;
import sdloader.javaee.ServletMapping;
import sdloader.javaee.WebAppContext;
import sdloader.javaee.WebAppManager;
import sdloader.javaee.impl.FilterConfigImpl;
import sdloader.javaee.impl.ServletConfigImpl;
import sdloader.javaee.impl.ServletContextImpl;
import sdloader.javaee.webxml.ContextParamTag;
import sdloader.javaee.webxml.FilterMappingTag;
import sdloader.javaee.webxml.FilterTag;
import sdloader.javaee.webxml.InitParamTag;
import sdloader.javaee.webxml.ListenerTag;
import sdloader.javaee.webxml.ServletMappingTag;
import sdloader.javaee.webxml.ServletTag;
import sdloader.javaee.webxml.WebXml;
import sdloader.util.ClassUtil;
import sdloader.util.CollectionsUtil;
import sdloader.util.WebUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalWebApplication {
    private WebXml webXml;
    private WebAppContext webAppContext;
    private ClassLoader webAppClassLoader;
    private WebAppManager manager;
    private ServletContextImpl servletContext;
    private Map<String, Servlet> servletMap;
    private Map<String, Filter> filterMap;
    private ListenerEventDispatcher listenerEventDispatcher;

    public InternalWebApplication(WebAppContext webAppContext, ClassLoader webAppClassLoader, WebAppManager manager) {
        this.webXml = webAppContext.getWebXml();
        this.webAppContext = webAppContext;
        this.webAppClassLoader = webAppClassLoader;
        this.manager = manager;
        this.init();
    }

    public WebAppManager getWebApplicationManager() {
        return this.manager;
    }

    public WebAppContext getWebAppContext() {
        return this.webAppContext;
    }

    public URL[] getDocBase() {
        return this.getWebAppContext().getDocBase();
    }

    public String getContextPath() {
        return this.getWebAppContext().getContextPath();
    }

    public ClassLoader getWebAppClassLoader() {
        return this.webAppClassLoader;
    }

    public WebXml getWebXml() {
        return this.webXml;
    }

    public ServletContextImpl getServletContext() {
        return this.servletContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.webAppClassLoader);
        try {
            this.initListener();
            this.initServletContext();
            this.initFilter();
            this.initServlet();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private void initServletContext() {
        this.servletContext = new ServletContextImpl(this);
        this.servletContext.setDocBase(this.getDocBase());
        this.servletContext.setServletContextName(this.getContextPath());
        for (ContextParamTag param : this.webXml.getWebApp().getContextParam()) {
            this.servletContext.addInitParameter(param.getParamName(), param.getParamValue());
        }
        ServletContextEvent contextEvent = new ServletContextEvent(this.servletContext);
        this.listenerEventDispatcher.dispatchServletContextListener_contextInitialized(contextEvent);
    }

    private void initFilter() {
        List<FilterTag> filterList = this.webXml.getWebApp().getFilter();
        for (FilterTag filterTag : filterList) {
            if (this.filterMap == null) {
                this.filterMap = CollectionsUtil.newHashMap();
            }
            Filter filterInstance = (Filter)ClassUtil.newInstance(filterTag.getFilterClass());
            FilterConfig config = this.createFilterConfig(filterTag);
            try {
                filterInstance.init(config);
            }
            catch (ServletException e) {
                throw new RuntimeException(e);
            }
            this.filterMap.put(filterTag.getFilterName(), filterInstance);
        }
    }

    private void initListener() {
        this.listenerEventDispatcher = new ListenerEventDispatcher();
        for (ListenerTag listenerTag : this.webXml.getWebApp().getListener()) {
            Object listenerImp = ClassUtil.newInstance(listenerTag.getListenerClass());
            this.listenerEventDispatcher.addListener(listenerImp);
        }
    }

    private void initServlet() {
        List<ServletTag> servletList = this.webXml.getWebApp().getServlet();
        LinkedList loadOnStartUpList = CollectionsUtil.newLinkedList();
        LinkedList noStartUpList = CollectionsUtil.newLinkedList();
        block2: for (ServletTag servletTag : servletList) {
            Integer loadOnStartUp = servletTag.getLoadOnStartup();
            if (loadOnStartUp == null || loadOnStartUp < 0) {
                noStartUpList.add(servletTag);
                continue;
            }
            for (int i = 0; i < loadOnStartUpList.size(); ++i) {
                int n = ((ServletTag)loadOnStartUpList.get(i)).getLoadOnStartup();
                if (loadOnStartUp >= n) continue;
                loadOnStartUpList.add(i, servletTag);
                continue block2;
            }
            loadOnStartUpList.add(servletTag);
        }
        servletList = loadOnStartUpList;
        servletList.addAll(noStartUpList);
        for (ServletTag servletTag : servletList) {
            if (this.servletMap == null) {
                this.servletMap = CollectionsUtil.newHashMap();
            }
            Servlet servletInstance = (Servlet)ClassUtil.newInstance(servletTag.getServletClass());
            ServletConfig config = this.createServletConfig(servletTag);
            try {
                servletInstance.init(config);
            }
            catch (ServletException e) {
                throw new RuntimeException(e);
            }
            this.servletMap.put(servletTag.getServletName(), servletInstance);
        }
        this.servletContext.setServletMap(this.servletMap);
    }

    private ServletConfig createServletConfig(ServletTag servletTag) {
        ServletConfigImpl config = new ServletConfigImpl();
        config.setServletContext(this.servletContext);
        for (InitParamTag initParam : servletTag.getInitParamList()) {
            config.addInitParameter(initParam.getParamName(), initParam.getParamValue());
        }
        config.setServletName(servletTag.getServletName());
        return config;
    }

    private FilterConfig createFilterConfig(FilterTag filterTag) {
        FilterConfigImpl config = new FilterConfigImpl();
        config.setServletContext(this.servletContext);
        for (InitParamTag initParam : filterTag.getInitParamList()) {
            config.addInitParameter(initParam.getParamName(), initParam.getParamValue());
        }
        config.setFilterName(filterTag.getFilterName());
        return config;
    }

    public List<Filter> findFilters(String resourcePath, String servletName, String dispatcherType) {
        ArrayList<Filter> filterList = CollectionsUtil.newArrayList();
        if (resourcePath != null && this.filterMap != null) {
            List<FilterMappingTag> mappingList = this.webXml.getWebApp().getFilterMapping();
            for (FilterMappingTag mapping : mappingList) {
                Set<String> dispatchers = mapping.getDispatchers();
                if (!dispatchers.isEmpty() ? !dispatchers.contains(dispatcherType) : !dispatcherType.equals("REQUEST")) continue;
                String patternText = mapping.getUrlPattern();
                if (patternText != null && WebUtil.matchPattern(patternText, resourcePath) != 0) {
                    String filterName = mapping.getFilterName();
                    Filter filter = this.filterMap.get(filterName);
                    if (filter == null) {
                        throw new RuntimeException("Filter not found. filterName=" + filterName);
                    }
                    filterList.add(filter);
                    continue;
                }
                String nameTest = mapping.getServletName();
                if (nameTest == null || !nameTest.equals(servletName)) continue;
                String filterName = mapping.getFilterName();
                Filter filter = this.filterMap.get(filterName);
                if (filter == null) {
                    throw new RuntimeException("Filter not found. filterName=" + filterName);
                }
                filterList.add(filter);
            }
        }
        return filterList;
    }

    public ServletMapping findServletMapping(String uri) {
        if (uri != null && this.servletMap != null) {
            uri = WebUtil.stripQueryPart(uri);
            ServletMapping targetServletMapping = null;
            int currentMatchType = 0;
            int currentPathMatchLength = 0;
            List<ServletMappingTag> mappingList = this.webXml.getWebApp().getServletMapping();
            for (ServletMappingTag mapping : mappingList) {
                String patternText = mapping.getUrlPattern();
                int matchType = WebUtil.matchPattern(patternText, uri);
                if (matchType == 0 || matchType < currentMatchType) continue;
                if (matchType == 4) {
                    ServletMapping servletMapping = new ServletMapping(mapping.getServletName(), patternText);
                    return servletMapping;
                }
                if (matchType == 3 && currentMatchType == 3 && patternText.length() <= currentPathMatchLength || matchType == 1 && currentMatchType == 1) continue;
                currentMatchType = matchType;
                currentPathMatchLength = patternText.length();
                targetServletMapping = new ServletMapping(mapping.getServletName(), patternText);
            }
            return targetServletMapping;
        }
        return null;
    }

    public Servlet findServlet(String servletName) {
        Servlet servlet = this.servletMap.get(servletName);
        if (servlet == null) {
            throw new RuntimeException("Servlet not found. servletName=" + servletName);
        }
        return servlet;
    }

    public List<Servlet> getServletList() {
        if (this.servletMap != null) {
            return CollectionsUtil.newArrayList(this.servletMap.values());
        }
        return null;
    }

    public ListenerEventDispatcher getListenerEventDispatcher() {
        return this.listenerEventDispatcher;
    }

    public List<Filter> getFilterList() {
        if (this.filterMap != null) {
            return CollectionsUtil.newArrayList(this.filterMap.values());
        }
        return null;
    }
}

