/*
 * Decompiled with CFR 0.152.
 */
package sdloader.internal.resource;

import java.net.MalformedURLException;
import java.net.URL;

public class WarProtocolBuilder {
    public static final String WAR_PROTOCOL = "war:";
    public static final String RESOURCE_SEPARATOR = "!";

    public static URL createArchiveResourceURL(URL archiveUrl, String resourcePath) {
        WarProtocolBuilder.assertBothNotNull(archiveUrl, resourcePath);
        String urlStr = archiveUrl.toExternalForm();
        StringBuilder builder = new StringBuilder();
        builder.append(urlStr);
        builder.append(RESOURCE_SEPARATOR);
        if (!resourcePath.startsWith("/")) {
            builder.append("/");
        }
        builder.append(resourcePath);
        return WarProtocolBuilder.createURL(builder);
    }

    public static URL innerjarUrl(URL rootUrl, String originalPath) {
        WarProtocolBuilder.assertBothNotNull(rootUrl, originalPath);
        String urlStr = rootUrl.toExternalForm();
        StringBuilder builder = new StringBuilder();
        builder.append("innerjar:");
        builder.append(urlStr);
        builder.append(RESOURCE_SEPARATOR);
        if (!originalPath.startsWith("/")) {
            builder.append("/");
        }
        builder.append(originalPath);
        return WarProtocolBuilder.createURL(builder);
    }

    public static URL classPathToUrl(URL rootUrl, String originalPath) {
        WarProtocolBuilder.assertBothNotNull(rootUrl, originalPath);
        String s = originalPath;
        String urlStr = rootUrl.toExternalForm();
        StringBuilder builder = new StringBuilder();
        builder.append(WAR_PROTOCOL);
        builder.append(urlStr);
        builder.append(RESOURCE_SEPARATOR);
        if (!originalPath.startsWith("/")) {
            builder.append("/");
        }
        builder.append(s);
        return WarProtocolBuilder.createURL(builder);
    }

    public static URL resourcePathToUrl(URL rootUrl, String originalPath) {
        WarProtocolBuilder.assertBothNotNull(rootUrl, originalPath);
        String urlStr = rootUrl.toExternalForm();
        StringBuilder builder = new StringBuilder();
        builder.append(WAR_PROTOCOL);
        builder.append(urlStr);
        builder.append(RESOURCE_SEPARATOR);
        if (!originalPath.startsWith("/")) {
            builder.append("/");
        }
        builder.append(originalPath);
        return WarProtocolBuilder.createURL(builder);
    }

    private static URL createURL(StringBuilder builder) {
        try {
            return new URL(null, builder.toString());
        }
        catch (MalformedURLException ignore) {
            return null;
        }
    }

    private static void assertBothNotNull(URL rootUrl, String originalPath) {
        if (rootUrl == null || originalPath == null) {
            throw new IllegalArgumentException();
        }
    }
}

