/*
 * Decompiled with CFR 0.152.
 */
package sdloader.internal.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import sdloader.internal.resource.Resource;

public class ResourceURLConnection
extends URLConnection {
    private Resource resource;

    public ResourceURLConnection(Resource resource) {
        super(resource != null ? resource.getURL() : null);
        this.resource = resource;
    }

    public void connect() throws IOException {
        this.checkNonNullResource();
    }

    public InputStream getInputStream() throws IOException {
        this.checkNonNullResource();
        return this.resource.getResourceAsInputStream();
    }

    public Resource getResource() {
        return this.resource;
    }

    private void checkNonNullResource() throws IOException {
        if (this.resource == null) {
            throw new IOException("Resource is null.");
        }
    }
}

