/*
 * Decompiled with CFR 0.152.
 */
package sdloader.internal.resource;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import sdloader.internal.resource.BranchTypeResource;
import sdloader.internal.resource.ClassTypeResourceImpl;
import sdloader.internal.resource.DirectoryTypeResourceImpl;
import sdloader.internal.resource.FileTypeResourceImpl;
import sdloader.internal.resource.JarArchiveTypeResourceImpl;
import sdloader.internal.resource.Resource;
import sdloader.internal.resource.ResourceBuilder;
import sdloader.util.CollectionsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceBuilderImpl
implements ResourceBuilder {
    @Override
    public Map<URL, Resource> build(String filepath) throws IOException {
        File file = new File(filepath);
        URL rootUrl = new URL("war:" + file.toURI().toURL().toExternalForm());
        JarInputStream ji = new JarInputStream(new FileInputStream(file));
        return this.build(rootUrl, ji);
    }

    public Map<URL, Resource> build(URL rootUrl, JarInputStream ji) throws IOException {
        JarEntry entry;
        HashMap<URL, Resource> resoureMap = CollectionsUtil.newHashMap();
        HashMap<String, Resource> pathMap = CollectionsUtil.newHashMap();
        while ((entry = ji.getNextJarEntry()) != null) {
            String resourcePath = entry.getName();
            byte[] bytes = ResourceBuilderImpl.getBytes(ji);
            Resource resourceType = this.getResourceType(rootUrl, resourcePath, bytes);
            this.addResource(resourceType, resourcePath, rootUrl, resoureMap, pathMap);
        }
        return resoureMap;
    }

    protected void addResource(Resource resourceType, String resourcePath, URL rootUrl, Map<URL, Resource> resoureMap, Map<String, Resource> pathMap) {
        if (!resourcePath.equals("/")) {
            int sepIndex;
            String parentPath;
            BranchTypeResource parent;
            String testPath = resourcePath;
            if (testPath.endsWith("/")) {
                testPath = testPath.substring(0, testPath.length() - 1);
            }
            if ((parent = (BranchTypeResource)pathMap.get(parentPath = (sepIndex = testPath.lastIndexOf("/")) < 0 ? "/" : testPath.substring(0, sepIndex + 1))) == null) {
                parent = new DirectoryTypeResourceImpl(rootUrl, parentPath);
                this.addResource(parent, parentPath, rootUrl, resoureMap, pathMap);
            }
            parent.addResource(resourceType);
        }
        resoureMap.put(resourceType.getURL(), resourceType);
        pathMap.put(resourcePath, resourceType);
    }

    protected static final byte[] getBytes(InputStream is) {
        byte[] bytes = null;
        byte[] buf = new byte[8192];
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int n = 0;
            while ((n = is.read(buf, 0, buf.length)) != -1) {
                baos.write(buf, 0, n);
            }
            bytes = baos.toByteArray();
        }
        catch (IOException ignore) {
            bytes = new byte[]{};
        }
        return bytes;
    }

    protected Resource getResourceType(URL rootUrl, String path, byte[] bytes) throws IOException {
        if (path.endsWith(".class")) {
            return new ClassTypeResourceImpl(rootUrl, path, bytes);
        }
        if (path.endsWith(".jar")) {
            JarArchiveTypeResourceImpl jarResource = new JarArchiveTypeResourceImpl(rootUrl, path, bytes);
            if (jarResource.isRuntimeNeeded()) {
                Map<URL, Resource> jarResources = this.build(jarResource.getURL(), new JarInputStream(new ByteArrayInputStream(bytes)));
                jarResource.setArchiveResources(jarResources);
            }
            return jarResource;
        }
        if (path.endsWith("/")) {
            return new DirectoryTypeResourceImpl(rootUrl, path);
        }
        return new FileTypeResourceImpl(rootUrl, path, bytes);
    }

    public static final String replaceFileSeparator(String filepath) {
        return filepath.replace('\\', '/');
    }

    public static final String stripJarArchivePath(String filepath) {
        return filepath.substring(filepath.indexOf("!") + 1, filepath.length());
    }
}

