/*
 * Decompiled with CFR 0.152.
 */
package sdloader.internal.resource;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import sdloader.internal.resource.ArchiveTypeResource;
import sdloader.internal.resource.Resource;
import sdloader.internal.resource.WarProtocolBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarArchiveTypeResourceImpl
implements ArchiveTypeResource {
    public static final String WEBINFLIB = "WEB-INF/lib";
    public static final String PROTOCOL = "innerjar:";
    protected String originalPath = null;
    protected String path = null;
    protected byte[] bytes = null;
    protected boolean runtimeNeeded;
    protected URL url;
    protected Map<URL, Resource> archiveResource;

    public JarArchiveTypeResourceImpl(URL rootUrl, String path, byte[] bytes) {
        this.originalPath = path;
        this.path = path;
        if (path.startsWith(WEBINFLIB)) {
            this.runtimeNeeded = true;
        } else {
            this.runtimeNeeded = false;
            this.bytes = bytes;
        }
        this.url = WarProtocolBuilder.innerjarUrl(rootUrl, this.originalPath);
    }

    @Override
    public String getOriginalPath() {
        return this.originalPath;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public byte[] getResourceAsBytes() {
        return this.bytes;
    }

    @Override
    public InputStream getResourceAsInputStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    @Override
    public boolean isRuntimeNeeded() {
        return this.runtimeNeeded;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    public void setArchiveResources(Map<URL, Resource> resources) {
        this.archiveResource = resources;
    }

    @Override
    public Resource getArchiveResource(String name) {
        URL resourceUrl = WarProtocolBuilder.createArchiveResourceURL(this.url, name);
        return this.archiveResource.get(resourceUrl);
    }
}

