/*
 * Decompiled with CFR 0.152.
 */
package sdloader.internal.resource;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import sdloader.internal.resource.DirectoryTypeResource;
import sdloader.internal.resource.Resource;
import sdloader.internal.resource.WarProtocolBuilder;
import sdloader.util.CollectionsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryTypeResourceImpl
implements DirectoryTypeResource {
    protected static final byte[] ZERO_LENGTH_BYTE = new byte[0];
    protected String path;
    protected String originalPath;
    protected URL url;
    protected List<Resource> childResources;

    public DirectoryTypeResourceImpl(URL rootUrl, String path) {
        this.path = path;
        this.originalPath = path;
        this.url = WarProtocolBuilder.createArchiveResourceURL(rootUrl, this.originalPath);
    }

    @Override
    public void addResource(Resource resource) {
        if (this.childResources == null) {
            this.childResources = CollectionsUtil.newArrayList();
        }
        this.childResources.add(resource);
    }

    @Override
    public void addResources(List<Resource> resources) {
        if (this.childResources == null) {
            this.childResources = CollectionsUtil.newArrayList();
        }
        this.childResources.addAll(resources);
    }

    @Override
    public List<Resource> getResources() {
        return this.childResources;
    }

    @Override
    public String getOriginalPath() {
        return this.path;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public byte[] getResourceAsBytes() {
        return ZERO_LENGTH_BYTE;
    }

    @Override
    public InputStream getResourceAsInputStream() {
        return new ByteArrayInputStream(ZERO_LENGTH_BYTE);
    }

    @Override
    public URL getURL() {
        return this.url;
    }
}

