/*
 * Decompiled with CFR 0.152.
 */
package sdloader.internal;

import java.util.Map;
import java.util.Properties;
import sdloader.util.BooleanUtil;
import sdloader.util.CollectionsUtil;

public class SDLoaderConfig {
    private Map<String, Object> setting = CollectionsUtil.newHashMap();

    public void clear() {
        this.setting.clear();
    }

    public void addAllIfNotExist(Properties p) {
        for (Object objKey : p.keySet()) {
            String key = (String)objKey;
            String value = p.getProperty(key);
            this.setConfigIfNotExit(key, value);
        }
    }

    public void addAll(Properties p) {
        for (Object objKey : p.keySet()) {
            String key = (String)objKey;
            String value = p.getProperty(key);
            this.setConfig(key, value);
        }
    }

    public Object setConfig(String key, Object value) {
        return this.setConfig(key, value, null);
    }

    public Object setConfig(String key, Object value, Object defaultValue) {
        Object setValue = value == null ? defaultValue : value;
        this.setting.put(key, setValue);
        return setValue;
    }

    public Object setConfigIfNotExit(String key, Object value) {
        return this.setConfigIfNotExit(key, value, null);
    }

    public Object setConfigIfNotExit(String key, Object value, Object defaultValue) {
        Object exitValue = this.getConfigIgnoreExist(key);
        if (exitValue == null) {
            this.setConfig(key, value, defaultValue);
            exitValue = value;
        }
        return exitValue;
    }

    public void setConfigFromSystemIfNotExit(String key) {
        Object value = this.getConfigIgnoreExist(key);
        if (value == null && (value = System.getProperty(key)) != null) {
            this.setConfig(key, value);
        }
    }

    public Object getConfig(String key) {
        return this.getConfig(key, null);
    }

    public Object getConfig(String key, Object defaultValue) {
        return this.getConfig(key, defaultValue, false);
    }

    public Object getConfigIgnoreExist(String key) {
        return this.getConfig(key, null, true);
    }

    public Object getConfigIgnoreExist(String key, Object defaultValue) {
        return this.getConfig(key, defaultValue, true);
    }

    protected Object getConfig(String key, Object defaultValue, boolean ignoreExist) {
        Object value = this.setting.get(key);
        if (value == null) {
            value = defaultValue;
        }
        if (value == null && !ignoreExist) {
            throw new RuntimeException("Config not found.key=" + key);
        }
        return value;
    }

    public String getConfigString(String key) {
        return this.getConfigString(key, null);
    }

    public String getConfigString(String key, String defaultValue) {
        Object value = this.getConfig(key, defaultValue);
        return value instanceof String ? (String)value : value.toString();
    }

    public String getConfigStringIgnoreExist(String key) {
        return this.getConfigStringIgnoreExist(key, null);
    }

    public String getConfigStringIgnoreExist(String key, String defaultValue) {
        Object value = this.getConfigIgnoreExist(key, defaultValue);
        if (value == null) {
            return null;
        }
        return value instanceof String ? (String)value : value.toString();
    }

    public Integer getConfigInteger(String key) {
        return this.getConfigInteger(key, null);
    }

    public Integer getConfigInteger(String key, Integer defaultValue) {
        Object value = this.getConfig(key, defaultValue);
        return value instanceof Integer ? (Integer)value : Integer.valueOf(value.toString());
    }

    public Integer getConfigIntegerIgnoreExist(String key) {
        return this.getConfigIntegerIgnoreExist(key, null);
    }

    public Integer getConfigIntegerIgnoreExist(String key, Integer defaultValue) {
        Object value = this.getConfigIgnoreExist(key, defaultValue);
        if (value == null) {
            return null;
        }
        return value instanceof Integer ? (Integer)value : Integer.valueOf(value.toString());
    }

    public Long getConfigLong(String key) {
        return this.getConfigLong(key, null);
    }

    public Long getConfigLong(String key, Long defaultValue) {
        Object value = this.getConfig(key, defaultValue);
        return value instanceof Long ? (Long)value : Long.valueOf(value.toString());
    }

    public Long getConfigLongIgnoreExist(String key) {
        return this.getConfigLongIgnoreExist(key, null);
    }

    public Long getConfigLongIgnoreExist(String key, Long defaultValue) {
        Object value = this.getConfigIgnoreExist(key, defaultValue);
        if (value == null) {
            return null;
        }
        return value instanceof Long ? (Long)value : Long.valueOf(value.toString());
    }

    public Boolean getConfigBoolean(String key) {
        return this.getConfigBoolean(key, null);
    }

    public Boolean getConfigBoolean(String key, Boolean defaultValue) {
        Object value = this.getConfig(key, defaultValue);
        return value instanceof Boolean ? (Boolean)value : BooleanUtil.toBoolean(value.toString());
    }

    public Boolean getConfigBooleanIgnoreExist(String key) {
        return this.getConfigBooleanIgnoreExist(key, null);
    }

    public Boolean getConfigBooleanIgnoreExist(String key, Boolean defaultValue) {
        Object value = this.getConfigIgnoreExist(key, defaultValue);
        if (value == null) {
            return null;
        }
        return value instanceof Boolean ? (Boolean)value : BooleanUtil.toBoolean(value.toString());
    }
}

