/*
 * Decompiled with CFR 0.152.
 */
package sdloader.http;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import sdloader.SDLoader;
import sdloader.http.HttpBody;
import sdloader.http.HttpHeader;
import sdloader.http.ProcessScopeContext;
import sdloader.internal.SDLoaderConfig;
import sdloader.util.CollectionsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequestParameters {
    private Map<String, String[]> paramMap;
    private List<String> paramNameList;
    private String defaultEncoding;
    private String bodyEncoding;
    private boolean useBodyEncodingForURI;
    private HttpHeader header;
    private HttpBody body;
    private boolean parameterInitialized;

    public HttpRequestParameters(HttpHeader header, HttpBody body) {
        this.header = header;
        this.body = body;
        String encode = "ISO-8859-1";
        boolean useBodyEncode = true;
        SDLoader loader = (SDLoader)ProcessScopeContext.getContext().getAttribute(SDLoader.class);
        if (loader != null) {
            SDLoaderConfig config = loader.getSDLoaderConfig();
            encode = config.getConfigString("sdloader.request.defaultEncode", encode);
            useBodyEncode = config.getConfigBoolean("sdloader.request.useBodyEncodingURI", useBodyEncode);
        }
        this.setDefaultEncoding(encode);
        this.setUseBodyEncodingForURI(useBodyEncode);
    }

    protected void initIfNeed() {
        if (!this.parameterInitialized) {
            this.initParameters();
            this.parameterInitialized = true;
        }
    }

    private void initParameters() {
        String contType;
        byte[] bodyData;
        this.paramMap = CollectionsUtil.newHashMap();
        this.paramNameList = CollectionsUtil.newLinkedList();
        if (this.header.getQueryString() != null) {
            String queryEncoding = this.isUseBodyEncodingForURI() ? this.bodyEncoding : this.defaultEncoding;
            this.parseRequestQuery(this.header.getQueryString(), queryEncoding);
        }
        if ((bodyData = this.body.getBodyData()) != null && this.header.getMethod().equalsIgnoreCase("POST") && (contType = this.header.getHeaderValue("Content-Type")) != null && (contType = contType.toLowerCase()).indexOf("application/x-www-form-urlencoded") != -1) {
            try {
                String bodyPartQueryString = new String(bodyData);
                this.parseRequestQuery(bodyPartQueryString, this.bodyEncoding);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void parseRequestQuery(String query, String encode) {
        StringTokenizer paramToken = new StringTokenizer(query, "&", false);
        while (paramToken.hasMoreElements()) {
            String param = paramToken.nextToken();
            StringTokenizer token = new StringTokenizer(param, "=", false);
            String key = token.nextToken();
            String value = "";
            if (token.hasMoreTokens()) {
                value = token.nextToken();
            }
            try {
                key = this.decode(key, encode);
                value = this.decode(value, encode);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(e);
            }
            this.addParameter(key, value);
        }
    }

    private String decode(String value, String encode) throws UnsupportedEncodingException {
        value = URLDecoder.decode(value, "ISO-8859-1");
        value = new String(value.getBytes("ISO-8859-1"), encode);
        return value;
    }

    public String getParamter(String key) {
        this.initIfNeed();
        String[] paramList = this.paramMap.get(key);
        if (paramList == null) {
            return null;
        }
        String param = paramList[0];
        return param;
    }

    public String[] getParamterValues(String key) {
        this.initIfNeed();
        String[] params = this.paramMap.get(key);
        if (params == null) {
            return null;
        }
        return params;
    }

    public Iterator<String> getParameterNames() {
        this.initIfNeed();
        return this.paramNameList.iterator();
    }

    public Map<String, String[]> getParamterMap() {
        this.initIfNeed();
        HashMap<String, String[]> newMap = CollectionsUtil.newHashMap();
        newMap.putAll(this.paramMap);
        return newMap;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
        this.setBodyEncoding(defaultEncoding);
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public void setBodyEncoding(String bodyEncoding) {
        this.bodyEncoding = bodyEncoding;
        this.parameterInitialized = false;
    }

    public String getBodyEncoding() {
        return this.bodyEncoding;
    }

    public void setUseBodyEncodingForURI(boolean useBodyEncodingForURI) {
        this.useBodyEncodingForURI = useBodyEncodingForURI;
        this.parameterInitialized = false;
    }

    public boolean isUseBodyEncodingForURI() {
        return this.useBodyEncodingForURI;
    }

    private void addParameter(String key, String value) {
        if (value == null) {
            return;
        }
        String[] params = this.paramMap.get(key);
        if (params == null) {
            params = new String[]{value};
            this.paramMap.put(key, params);
            this.paramNameList.add(key);
        } else {
            String[] newParams = new String[params.length + 1];
            System.arraycopy(params, 0, newParams, 0, params.length);
            newParams[newParams.length - 1] = value;
            this.paramMap.put(key, newParams);
        }
    }
}

