/*
 * Decompiled with CFR 0.152.
 */
package sdloader.http;

import java.io.IOException;
import sdloader.http.HttpBody;
import sdloader.http.HttpHeader;
import sdloader.http.HttpRequestParameters;
import sdloader.http.HttpRequestReader;

public class HttpRequest {
    public static final String KEY_REQUEST_DEFAULT_ENCODE = "sdloader.request.defaultEncode";
    public static final String KEY_REQUEST_USE_BODY_ENCODEING_FOR_URI = "sdloader.request.useBodyEncodingURI";
    public static final String KEY_REQUEST_URI_ENCODING = "sdloader.request.URIEncoding";
    private HttpRequestReader requestReader;
    private HttpHeader header;
    private HttpBody body;
    private HttpRequestParameters parameters;

    public HttpRequest(HttpRequestReader requestReader) {
        this.requestReader = requestReader;
    }

    public void readRequest() throws IOException {
        this.createHttpRequestHeader();
        this.createHttpRequestBody();
        this.parameters = new HttpRequestParameters(this.header, this.body);
    }

    public HttpRequestParameters getParameters() {
        return this.parameters;
    }

    public HttpHeader getHeader() {
        return this.header;
    }

    public HttpBody getBody() {
        return this.body;
    }

    private void createHttpRequestHeader() throws IOException {
        StringBuilder httpHeaderBuf = new StringBuilder();
        String line = null;
        while ((line = this.requestReader.readHeaderLine()).length() == 0) {
        }
        while (line.length() != 0) {
            httpHeaderBuf.append(line);
            httpHeaderBuf.append("\r\n");
            line = this.requestReader.readHeaderLine();
        }
        this.header = new HttpHeader(new String(httpHeaderBuf));
    }

    private void createHttpRequestBody() throws IOException {
        String contentLengthHeader = this.header.getHeaderValue("Content-Length");
        byte[] b = null;
        int contentLength = 0;
        if (contentLengthHeader != null) {
            contentLength = Integer.parseInt(contentLengthHeader);
            long trueContentLength = Long.parseLong(contentLengthHeader);
            if (trueContentLength > (long)contentLength) {
                throw new IllegalArgumentException("ContentLenght too long.Max size = 2147483647");
            }
        }
        b = new byte[contentLength];
        this.requestReader.readBody(b);
        this.body = new HttpBody(b);
    }
}

