/*
 * Decompiled with CFR 0.152.
 */
package sdloader.http;

import java.util.List;
import sdloader.http.HttpProcessor;
import sdloader.log.SDLoaderLog;
import sdloader.log.SDLoaderLogFactory;
import sdloader.util.CollectionsUtil;

public class HttpProcessorPool {
    private static final SDLoaderLog log = SDLoaderLogFactory.getLog(HttpProcessor.class);
    private int nextProcessorNo;
    private int maxThreadPoolNum;
    private List<HttpProcessor> processorPool = CollectionsUtil.newLinkedList();
    private boolean stop;

    public HttpProcessorPool(int maxThreadPoolNum) {
        this.maxThreadPoolNum = maxThreadPoolNum;
        for (int i = 0; i < maxThreadPoolNum; ++i) {
            String processorName = "HttpProcessor:init" + i;
            HttpProcessor processor = this.createProcessor(processorName);
            this.processorPool.add(processor);
        }
        this.nextProcessorNo = maxThreadPoolNum + 1;
    }

    private HttpProcessor createProcessor(String processorName) {
        HttpProcessor processor = new HttpProcessor(processorName);
        processor.start();
        log.debug("create " + processor.getName());
        return processor;
    }

    public synchronized HttpProcessor borrowProcessor() {
        if (this.processorPool.isEmpty()) {
            String processorName = "HttpProcessor:" + this.nextProcessorNo++;
            return this.createProcessor(processorName);
        }
        HttpProcessor processor = this.processorPool.remove(0);
        log.debug("reuse " + processor.getName());
        return processor;
    }

    public synchronized void returnProcessor(HttpProcessor processor) {
        if (this.stop) {
            return;
        }
        if (this.processorPool.size() < this.maxThreadPoolNum) {
            log.debug("return " + processor.getName());
            this.processorPool.add(processor);
        } else {
            log.debug("stop " + processor.getName());
            processor.stopProcessor();
        }
    }

    public synchronized void stop() {
        if (!this.stop) {
            this.stop = true;
            for (HttpProcessor processor : this.processorPool) {
                processor.stopProcessor();
            }
        }
    }
}

