/*
 * Decompiled with CFR 0.152.
 */
package sdloader.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.Calendar;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import sdloader.SDLoader;
import sdloader.http.HttpHeader;
import sdloader.http.HttpRequest;
import sdloader.http.HttpRequestReader;
import sdloader.http.ProcessScopeContext;
import sdloader.javaee.InternalWebApplication;
import sdloader.javaee.ServletMapping;
import sdloader.javaee.impl.FilterChainImpl;
import sdloader.javaee.impl.HttpServletRequestImpl;
import sdloader.javaee.impl.HttpServletResponseImpl;
import sdloader.javaee.impl.ServletContextImpl;
import sdloader.log.SDLoaderLog;
import sdloader.log.SDLoaderLogFactory;
import sdloader.util.FastByteArrayOutputStream;
import sdloader.util.QoSInputStream;
import sdloader.util.QoSOutputStream;
import sdloader.util.WebUtil;

public class HttpProcessor
extends Thread {
    private static final SDLoaderLog log = SDLoaderLogFactory.getLog(HttpProcessor.class);
    private int socketTimeout = 60000;
    private int keepAliveTimeout = 15000;
    private int keppAliveMaxRequests = 100;
    private Socket socket;
    private SDLoader sdLoader;
    private int lineSpeed;
    private boolean stop;
    private boolean started;
    private boolean wait = true;

    public HttpProcessor(String name) {
        super(name);
        this.setDaemon(true);
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void setKeepAliveTimeout(int keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public void setKeppAliveMaxRequests(int keppAliveMaxRequests) {
        this.keppAliveMaxRequests = keppAliveMaxRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Socket socket, SDLoader loader) {
        HttpProcessor httpProcessor = this;
        synchronized (httpProcessor) {
            this.socket = socket;
            this.sdLoader = loader;
            this.lineSpeed = this.sdLoader.getSDLoaderConfig().getConfigInteger("sdloader.lineSpeed", -1);
            if (this.started) {
                this.notify();
            } else {
                this.wait = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopProcessor() {
        HttpProcessor httpProcessor = this;
        synchronized (httpProcessor) {
            this.stop = true;
            if (this.started) {
                this.notify();
            } else {
                this.wait = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.stop) {
            try {
                HttpProcessor httpProcessor = this;
                synchronized (httpProcessor) {
                    this.started = true;
                    if (this.wait) {
                        this.wait();
                    }
                    this.wait = true;
                }
            }
            catch (InterruptedException e) {
                continue;
            }
            if (this.stop) {
                return;
            }
            this.processSocket();
        }
    }

    /*
     * Exception decompiling
     */
    protected void processSocket() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpRequest processReadRequest(InputStream is) throws IOException {
        try {
            HttpRequestReader reader = new HttpRequestReader(new QoSInputStream(is, this.lineSpeed));
            HttpRequest httpRequest = new HttpRequest(reader);
            log.debug("request read start.");
            httpRequest.readRequest();
            log.debug("request read success.");
            if (log.isDebugEnabled()) {
                log.debug("<REQUEST_HEADER>\n" + httpRequest.getHeader().getRequestHeader());
            }
            HttpRequest httpRequest2 = httpRequest;
            return httpRequest2;
        }
        finally {
            if (this.socket.isClosed()) {
                throw new SocketException();
            }
            this.socket.setSoTimeout(this.socketTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processServlet(HttpRequest httpRequest, OutputStream os, int requestCount) throws Throwable {
        HttpHeader header = httpRequest.getHeader();
        String requestURI = header.getRequestURI();
        InternalWebApplication webapp = this.sdLoader.getWebAppManager().findWebApp(requestURI);
        HttpServletRequestImpl request = this.createServletRequestImp(httpRequest, webapp);
        HttpServletResponseImpl response = new HttpServletResponseImpl();
        ServletContextImpl servletContextImpl = webapp.getServletContext();
        String contextPath = webapp.getContextPath();
        String resourcePath = WebUtil.getResourcePath(contextPath, requestURI);
        if (!requestURI.equals("/") && resourcePath == null) {
            response.setStatus(302);
            resourcePath = requestURI + "/";
            String host = request.getHeader("Host");
            if (host == null) {
                host = request.getLocalName() + ":" + request.getLocalPort();
            }
            response.addHeader("Location", WebUtil.buildRequestURL(request.getScheme(), host, resourcePath).toString());
            this.setDefaultResponseHeader(servletContextImpl, request, response, requestCount);
            this.processRequestEnd(response, os);
            return;
        }
        ServletMapping mapping = webapp.findServletMapping(resourcePath);
        if (mapping == null) {
            WebUtil.writeNotFoundPage(response);
            this.setDefaultResponseHeader(servletContextImpl, request, response, requestCount);
            this.processRequestEnd(response, os);
            return;
        }
        Servlet servlet = webapp.findServlet(mapping.getServletName());
        request.setServletPath(WebUtil.getServletPath(mapping.getUrlPattern(), resourcePath));
        request.setPathInfo(WebUtil.getPathInfo(mapping.getUrlPattern(), resourcePath));
        ClassLoader webClassLoader = webapp.getWebAppClassLoader();
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(webClassLoader);
            ProcessScopeContext processScopeContext = ProcessScopeContext.getContext();
            processScopeContext.setRequest(request);
            processScopeContext.setResponse(response);
            request.intoScope();
            try {
                String servletName = mapping.getServletName();
                List<Filter> filterList = webapp.findFilters(resourcePath, servletName, "REQUEST");
                if (filterList.size() > 0) {
                    Filter[] filters = filterList.toArray(new Filter[0]);
                    FilterChainImpl filterChain = new FilterChainImpl(filters, servlet);
                    filterChain.doFilter(request, response);
                } else {
                    servlet.service(request, response);
                }
            }
            catch (ServletException se) {
                log.error(se.getMessage(), se);
                response.setStatus(500);
            }
            catch (IOException ioe) {
                log.error(ioe.getMessage(), ioe);
                response.setStatus(500);
            }
            this.setDefaultResponseHeader(servletContextImpl, request, response, requestCount);
            this.processRequestEnd(response, os);
        }
        finally {
            request.destroy();
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    private HttpServletRequestImpl createServletRequestImp(HttpRequest httpRequest, InternalWebApplication webApp) {
        HttpServletRequestImpl request = new HttpServletRequestImpl(httpRequest, webApp, this.sdLoader.getSessionManager());
        request.setServerPort(this.sdLoader.getPort());
        request.setLocalPort(this.socket.getLocalPort());
        request.setLocalAddr(this.socket.getLocalAddress().getHostAddress());
        request.setLocalName(this.socket.getLocalAddress().getHostName());
        request.setRemotePort(this.socket.getPort());
        request.setRemoteAddr(this.socket.getInetAddress().getHostAddress());
        request.setRemoteHost(this.socket.getInetAddress().getHostName());
        request.setScheme("http");
        String uriEncoding = this.sdLoader.getSDLoaderConfig().getConfigStringIgnoreExist("sdloader.request.URIEncoding");
        if (uriEncoding != null) {
            request.setUriEncoding(uriEncoding);
        }
        return request;
    }

    protected void setDefaultResponseHeader(ServletContextImpl servletContextImpl, HttpServletRequestImpl request, HttpServletResponseImpl response, int requestCount) throws IOException {
        HttpHeader resHeader;
        String transferEncoding;
        response.setHeader("Date", WebUtil.formatHeaderDate(Calendar.getInstance().getTime()));
        response.setHeader("Server", this.sdLoader.getServerName());
        HttpSession session = request.getSession(false);
        if (session != null && servletContextImpl != null) {
            String sessionId = session.getId();
            Cookie sessionCookie = new Cookie("JSESSIONID", sessionId);
            sessionCookie.setPath(servletContextImpl.getContextPath());
            response.addCookie(sessionCookie);
        }
        if (request.getHeader().isKeepAlive() && requestCount < this.keppAliveMaxRequests) {
            response.addHeader("Keep-Alive", "timeout=" + this.keepAliveTimeout / 1000 + ", max=" + this.keppAliveMaxRequests);
            response.addHeader("Connection", "Keep-Alive");
        } else {
            response.addHeader("Connection", "close");
        }
        if (this.sdLoader.getSDLoaderConfig().getConfigBoolean("sdloader.response.useNoCacheMode", false).booleanValue()) {
            response.setHeader("Pragma", "no-cache");
            response.setDateHeader("Expires", 1L);
            response.setHeader("Cache-Control", "no-cache");
            response.addHeader("Cache-Control", "no-store");
        }
        if ((transferEncoding = (resHeader = response.getResponseHeader()).getHeaderValue("Transfer-Encoding")) == null || !transferEncoding.equalsIgnoreCase("chunked")) {
            response.setHeader("Content-Length", String.valueOf(response.getBodySize()));
        }
    }

    private void processRequestEnd(HttpServletResponseImpl response, OutputStream os) throws IOException {
        HttpHeader resHeader = response.getResponseHeader();
        os = new QoSOutputStream(os, this.lineSpeed);
        byte[] headerData = resHeader.buildResponseHeader().getBytes();
        os.write(headerData);
        if (log.isDebugEnabled()) {
            log.debug("<RESPONSE_HEADER>\n" + new String(headerData));
        }
        os.write("\r\n".getBytes());
        FastByteArrayOutputStream bodyData = response.getBodyData();
        if (bodyData != null) {
            bodyData.writeTo(os);
        }
        os.flush();
    }
}

