/*
 * Decompiled with CFR 0.152.
 */
package sdloader.http;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;
import sdloader.http.HttpConst;
import sdloader.util.CollectionsUtil;
import sdloader.util.WebUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpHeader {
    private String requestHeader;
    private String method;
    private String requestURI;
    private String queryString;
    private int statusCode = 200;
    private String status = HttpConst.findStatus(200);
    private String version = "HTTP/1.1";
    private List<HeaderData> headerList = CollectionsUtil.newArrayList();
    private List<Cookie> cookieList = CollectionsUtil.newArrayList();

    public String getMethod() {
        return this.method;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public String getVersion() {
        return this.version;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public HttpHeader() {
    }

    public HttpHeader(String requestHeader) {
        if (requestHeader == null) {
            throw new IllegalArgumentException("Http header is null.");
        }
        this.requestHeader = requestHeader;
        this.parseHttpRequest(requestHeader);
    }

    private void parseHttpRequest(String httpRequest) {
        String line;
        StringTokenizer token = new StringTokenizer(httpRequest, "\r\n", false);
        if (token.hasMoreTokens()) {
            String requestLine = token.nextToken();
            this.parseRequestPathLine(requestLine);
        } else {
            throw new IllegalArgumentException("Invalid http request.");
        }
        while (token.hasMoreTokens() && (line = token.nextToken()).trim().length() > 0) {
            int nameEnd = line.indexOf(": ");
            String name = line.substring(0, nameEnd).trim().toLowerCase();
            String value = null;
            int valueStart = nameEnd + ": ".length();
            if (line.length() > valueStart) {
                value = line.substring(valueStart, line.length());
            }
            if (name.equalsIgnoreCase("Cookie")) {
                this.parseCookie(value);
                continue;
            }
            this.addHeader(name, value);
        }
    }

    private void parseRequestPathLine(String requestLine) {
        StringTokenizer token = new StringTokenizer(requestLine, " ", false);
        if (!token.hasMoreTokens()) {
            throw new IllegalArgumentException("Invalid http request. method not found.");
        }
        this.method = token.nextToken().trim();
        if (token.hasMoreTokens()) {
            String request = token.nextToken().trim();
            int paramDelim = request.indexOf("?");
            if (paramDelim > 0) {
                this.requestURI = request.substring(0, paramDelim);
                this.queryString = request.substring(paramDelim + 1, request.length());
            } else {
                this.requestURI = request;
            }
        } else {
            throw new IllegalArgumentException("Invalid http request. requestURI not found.");
        }
        if (!token.hasMoreTokens()) {
            throw new IllegalArgumentException("Invalid http request. version not found.");
        }
        this.version = token.nextToken().trim();
    }

    private void parseCookie(String cookieValue) {
        if (cookieValue == null || cookieValue.length() <= 0) {
            return;
        }
        StringTokenizer token = new StringTokenizer(cookieValue, "; ", false);
        while (token.hasMoreTokens()) {
            String keyValue = token.nextToken();
            int delimIndex = keyValue.indexOf("=");
            String key = keyValue.substring(0, delimIndex);
            String value = keyValue.substring(delimIndex + 1, keyValue.length());
            Cookie cookie = new Cookie(key, value);
            this.cookieList.add(cookie);
        }
    }

    public void addHeader(String name, String value) {
        this.headerList.add(new HeaderData(name, value));
    }

    public void setHeader(String name, String value) {
        boolean exist = false;
        for (HeaderData data : this.headerList) {
            if (!data.getName().equalsIgnoreCase(name)) continue;
            data.value = value;
            exist = true;
        }
        if (!exist) {
            this.addHeader(name, value);
        }
    }

    public List<String> getHeaderNameList() {
        ArrayList<String> headerFieldNameList = CollectionsUtil.newArrayList();
        for (HeaderData data : this.headerList) {
            headerFieldNameList.add(data.getName());
        }
        return headerFieldNameList;
    }

    public String getHeaderValue(String headerName) {
        for (HeaderData data : this.headerList) {
            if (!data.getName().equalsIgnoreCase(headerName)) continue;
            return data.getValue();
        }
        return null;
    }

    public List<String> getHeaderValueList(String headerName) {
        ArrayList<String> headerValueList = CollectionsUtil.newArrayList();
        for (HeaderData data : this.headerList) {
            if (!data.getName().equalsIgnoreCase(headerName)) continue;
            headerValueList.add(data.getValue());
        }
        return headerValueList;
    }

    public void addCookie(Cookie newCookie) {
        this.cookieList.add(newCookie);
    }

    public Cookie getCookie(String name) {
        for (Cookie cookie : this.cookieList) {
            if (!cookie.getName().equals(name)) continue;
            return cookie;
        }
        return null;
    }

    public List<Cookie> getCookieList() {
        return this.cookieList;
    }

    public boolean isKeepAlive() {
        String keepAliveHeader = this.getHeaderValue("Keep-Alive");
        if (keepAliveHeader != null && keepAliveHeader.equalsIgnoreCase("close")) {
            return false;
        }
        if (this.version.equals("HTTP/1.1")) {
            return true;
        }
        String connection = this.getHeaderValue("Connection");
        return connection.equalsIgnoreCase("Keep-Alive");
    }

    public String buildResponseHeader() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.version + " " + this.statusCode + " " + this.status + "\r\n");
        for (HeaderData headerData : this.headerList) {
            String headerName = headerData.getName();
            String headerValue = headerData.getValue();
            buf.append(headerName + ": " + headerValue + "\r\n");
        }
        for (Cookie cookie : this.cookieList) {
            if (cookie.getValue() == null) continue;
            buf.append("Set-Cookie: ");
            buf.append(cookie.getName() + "=" + cookie.getValue());
            if (cookie.getMaxAge() > 0) {
                Calendar now = Calendar.getInstance();
                now.add(13, cookie.getMaxAge());
                buf.append("; expires=" + WebUtil.formatCookieDate(now.getTime()));
            }
            if (cookie.getPath() != null) {
                buf.append("; path=" + cookie.getPath());
            }
            if (cookie.getDomain() != null) {
                buf.append("; domain=" + cookie.getDomain());
            }
            if (cookie.getSecure()) {
                buf.append("; secure");
            }
            buf.append("\r\n");
        }
        return buf.toString();
    }

    public String getRequestHeader() {
        return this.requestHeader;
    }

    protected static class HeaderData {
        private String name;
        private String value;

        public HeaderData(String aName, String aValue) {
            this.name = aName;
            this.value = aValue;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

