/*
 * Decompiled with CFR 0.152.
 */
package sdloader.http;

import java.util.Map;
import sdloader.util.CollectionsUtil;

public class HttpConst {
    public static final String HTTP_1_1 = "HTTP/1.1";
    public static final String SESSIONID_KEY = "JSESSIONID";
    public static final String CACHECONTROL = "Cache-Control";
    public static final String CONNECTION = "Connection";
    public static final String CONTENTLENGTH = "Content-Length";
    public static final String CONTENTRANGE = "Content-Range";
    public static final String CONTENTTYPE = "Content-Type";
    public static final String EXPIRES = "Expires";
    public static final String DATE = "Date";
    public static final String PRAGMA = "Pragma";
    public static final String TRANSFERENCODING = "Transfer-Encoding";
    public static final String LASTMODIFIED = "Last-Modified";
    public static final String ACCEPT = "Accept";
    public static final String HOST = "Host";
    public static final String IFMODIFIEDSINCE = "If-Modified-Since";
    public static final String KEEPALIVE = "Keep-Alive";
    public static final String USERAGENT = "User-Agent";
    public static final String SERVER = "Server";
    public static final String COOKIE = "Cookie";
    public static final String SETCOOKIE = "Set-Cookie";
    public static final String LOCATION = "Location";
    public static final String CHUNKED = "chunked";
    public static final String CLOSE = "close";
    public static final String WWW_FORM_URLENCODE = "application/x-www-form-urlencoded";
    public static final String POST = "POST";
    public static final String GET = "GET";
    public static final String HEAD = "HEAD";
    public static final String PUT = "PUT";
    public static final String DELETE = "DELETE";
    public static final String TRACE = "TRACE";
    public static final String OPTION = "OPTION";
    public static final String CRLF_STRING = "\r\n";
    public static final String COLON_STRING = ": ";
    public static final String SEMI_COLON_STRING = "; ";
    public static final int SC_CONTINUE = 100;
    public static final int SC_SWITCHING_PROTOCOLS = 101;
    public static final int SC_OK = 200;
    public static final int SC_CREATED = 201;
    public static final int SC_ACCEPTED = 202;
    public static final int SC_NON_AUTHORITATIVE_INFORMATION = 203;
    public static final int SC_NO_CONTENT = 204;
    public static final int SC_RESET_CONTENT = 205;
    public static final int SC_PARTIAL_CONTENT = 206;
    public static final int SC_MULTIPLE_CHOICES = 300;
    public static final int SC_MOVED_PERMANENTLY = 301;
    public static final int SC_MOVED_TEMPORARILY = 302;
    public static final int SC_SEE_OTHER = 303;
    public static final int SC_NOT_MODIFIED = 304;
    public static final int SC_USE_PROXY = 305;
    public static final int SC_TEMPORARY_REDIRECT = 307;
    public static final int SC_BAD_REQUEST = 400;
    public static final int SC_UNAUTHORIZED = 401;
    public static final int SC_PAYMENT_REQUIRED = 402;
    public static final int SC_FORBIDDEN = 403;
    public static final int SC_NOT_FOUND = 404;
    public static final int SC_METHOD_NOT_ALLOWED = 405;
    public static final int SC_NOT_ACCEPTABLE = 406;
    public static final int SC_PROXY_AUTHENTICATION_REQUIRED = 407;
    public static final int SC_REQUEST_TIMEOUT = 408;
    public static final int SC_CONFLICT = 409;
    public static final int SC_GONE = 410;
    public static final int SC_LENGTH_REQUIRED = 411;
    public static final int SC_PRECONDITION_FAILED = 412;
    public static final int SC_REQUEST_ENTITY_TOO_LARGE = 413;
    public static final int SC_REQUEST_URI_TOO_LONG = 414;
    public static final int SC_UNSUPPORTED_MEDIA_TYPE = 415;
    public static final int SC_REQUESTED_RANGE_NOT_SATISFIABLE = 416;
    public static final int SC_EXPECTATION_FAILED = 417;
    public static final int SC_INTERNAL_SERVER_ERROR = 500;
    public static final int SC_NOT_IMPLEMENTED = 501;
    public static final int SC_BAD_GATEWAY = 502;
    public static final int SC_SERVICE_UNAVAILABLE = 503;
    public static final int SC_GATEWAY_TIMEOUT = 504;
    public static final int SC_HTTP_VERSION_NOT_SUPPORTED = 505;
    private static Map<Integer, String> statusMap = CollectionsUtil.newHashMap(50);

    public static String findStatus(int statusCode) {
        return statusMap.get(new Integer(statusCode));
    }

    private HttpConst() {
    }

    static {
        statusMap.put(new Integer(100), "Continue");
        statusMap.put(new Integer(101), "Switching Protocols");
        statusMap.put(new Integer(200), "OK");
        statusMap.put(new Integer(201), "Created");
        statusMap.put(new Integer(202), "Accepted");
        statusMap.put(new Integer(203), "Non-Authoritative Information");
        statusMap.put(new Integer(204), "No Content");
        statusMap.put(new Integer(205), "Reset Content");
        statusMap.put(new Integer(206), "Partial Content");
        statusMap.put(new Integer(300), "Multiple Choices");
        statusMap.put(new Integer(301), "Moved Permanently");
        statusMap.put(new Integer(302), "Moved Temporarily");
        statusMap.put(new Integer(303), "See Other");
        statusMap.put(new Integer(304), "Not Modified");
        statusMap.put(new Integer(305), "Use Proxy");
        statusMap.put(new Integer(307), "Temporary Redirect");
        statusMap.put(new Integer(400), "Bad Request");
        statusMap.put(new Integer(401), "Unauthorized");
        statusMap.put(new Integer(402), "Payment Required");
        statusMap.put(new Integer(403), "Forbidden");
        statusMap.put(new Integer(404), "Not Found");
        statusMap.put(new Integer(405), "Method Not Allowed");
        statusMap.put(new Integer(406), "Not Acceptable");
        statusMap.put(new Integer(407), "Proxy Authentication Required");
        statusMap.put(new Integer(408), "Request Time-out");
        statusMap.put(new Integer(409), "Conflict");
        statusMap.put(new Integer(410), "Gone");
        statusMap.put(new Integer(411), "Length Required");
        statusMap.put(new Integer(412), "Precondition Failed");
        statusMap.put(new Integer(413), "Request Entity Too Large");
        statusMap.put(new Integer(414), "Request-URI Too Large");
        statusMap.put(new Integer(415), "Unsupported Media Type");
        statusMap.put(new Integer(416), "Requested Range Not Satisfiable");
        statusMap.put(new Integer(417), "Expectation Failed");
        statusMap.put(new Integer(500), "Internal Server Error");
        statusMap.put(new Integer(501), "Not Implemented");
        statusMap.put(new Integer(502), "Bad Gateway");
        statusMap.put(new Integer(503), "Service Unavailable");
        statusMap.put(new Integer(504), "Gateway Time-out");
        statusMap.put(new Integer(505), "HTTP Version not supported");
    }
}

