/*
 * Decompiled with CFR 0.152.
 */
package sdloader.event;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import sdloader.event.Event;
import sdloader.util.CollectionsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventDispatcher<L, E extends Event<?>> {
    private String invokeMethodName;
    private Map<String, List<L>> listenerMap = CollectionsUtil.newHashMap();

    public EventDispatcher(String invokeMethodName) {
        this.invokeMethodName = invokeMethodName;
    }

    public EventDispatcher(Class<?> listenerClass) {
        this.detectInvokeMethod(listenerClass);
    }

    public void addEventListener(String type, L listener) {
        List<L> listenerList = this.listenerMap.get(type);
        if (listenerList == null) {
            listenerList = CollectionsUtil.newArrayList();
            this.listenerMap.put(type, listenerList);
        }
        listenerList.add(listener);
    }

    public void removeEventListener(String type, L listener) {
        List<L> listenerList = this.listenerMap.get(type);
        if (listenerList != null) {
            while (listenerList.remove(listener)) {
            }
        }
    }

    public void clear(String type) {
        this.listenerMap.remove(type);
    }

    public void clearAll() {
        this.listenerMap.clear();
    }

    public void dispatchEvent(E event) {
        List<L> listenerList = this.listenerMap.get(((Event)event).getType());
        if (listenerList != null) {
            for (L listener : listenerList) {
                this.invoke(listener, event);
            }
        }
    }

    protected void detectInvokeMethod(Class<?> listener) {
        Method[] methods = listener.getMethods();
        if (methods.length != 1) {
            throw new RuntimeException("invoke method detect fail.");
        }
        this.invokeMethodName = methods[0].getName();
    }

    protected void invoke(L listener, E event) {
        try {
            Method method = listener.getClass().getDeclaredMethod(this.invokeMethodName, event.getClass());
            if (method == null) {
                throw new NoSuchMethodError(this.invokeMethodName);
            }
            method.setAccessible(true);
            method.invoke(listener, event);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

