/*
 * Decompiled with CFR 0.152.
 */
package sdloader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import sdloader.SDLoader;
import sdloader.log.SDLoaderLog;
import sdloader.log.SDLoaderLogFactory;
import sdloader.util.Browser;

public class SystemTrayOpen {
    private static final SDLoaderLog log = SDLoaderLogFactory.getLog(SystemTrayOpen.class);
    private SDLoader server;

    public static void main(String[] args) {
        new SystemTrayOpen().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            this.server = new SDLoader();
            this.server.setAutoPortDetect(true);
            this.server.start();
            this.openBrowser();
            this.createSystemTray(this.server);
            this.server.stop();
        }
        catch (Throwable e) {
            log.error("SDLoader catch error.", e);
        }
        finally {
            System.exit(0);
        }
    }

    private InputStream getIconInputStream() {
        try {
            InputStream iconStream = null;
            File icon = new File("trayicon.gif");
            iconStream = icon.exists() ? new FileInputStream(icon) : SystemTrayOpen.class.getResourceAsStream("/sdloader/resource/trayicon.gif");
            return iconStream;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    private void openBrowser() {
        try {
            int port = this.server.getPort();
            String url = "http://localhost:" + port;
            Browser.open(url);
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    private void createSystemTray(final SDLoader sdLoader) {
        final Display display = new Display();
        Shell shell = new Shell(display);
        Image image = new Image((Device)display, this.getIconInputStream());
        Tray tray = display.getSystemTray();
        if (tray == null) {
            log.info("System tray not found.");
        } else {
            TrayItem item = new TrayItem(tray, 0);
            item.setImage(image);
            item.setToolTipText("SDLoader port:" + sdLoader.getPort());
            final Menu menu = new Menu(shell, 8);
            item.addListener(35, new Listener(){

                public void handleEvent(Event event) {
                    menu.setVisible(true);
                }
            });
            MenuItem shutdownItem = new MenuItem(menu, 8);
            shutdownItem.setText("shutdown");
            shutdownItem.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    sdLoader.stop();
                    display.dispose();
                }
            });
            MenuItem portItem = new MenuItem(menu, 0);
            portItem.setText("port:" + sdLoader.getPort());
            portItem.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SystemTrayOpen.this.openBrowser();
                }
            });
            MenuItem browserItem = new MenuItem(menu, 8);
            browserItem.setText("open browser");
            browserItem.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SystemTrayOpen.this.openBrowser();
                }
            });
            menu.setDefaultItem(browserItem);
        }
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        image.dispose();
        display.dispose();
    }
}

