/*
 * Decompiled with CFR 0.152.
 */
package sdloader;

import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessControlException;
import java.util.Properties;
import sdloader.event.EventDispatcher;
import sdloader.http.HttpProcessor;
import sdloader.http.HttpProcessorPool;
import sdloader.internal.SDLoaderConfig;
import sdloader.javaee.SessionManager;
import sdloader.javaee.WebAppContext;
import sdloader.javaee.WebAppManager;
import sdloader.javaee.constants.JavaEEConstants;
import sdloader.lifecycle.Lifecycle;
import sdloader.lifecycle.LifecycleEvent;
import sdloader.lifecycle.LifecycleListener;
import sdloader.log.SDLoaderLog;
import sdloader.log.SDLoaderLogFactory;
import sdloader.util.ClassUtil;
import sdloader.util.DisposableUtil;
import sdloader.util.IOUtil;
import sdloader.util.PathUtil;
import sdloader.util.ResourceUtil;

public class SDLoader
implements Lifecycle {
    private static final SDLoaderLog log = SDLoaderLogFactory.getLog(SDLoader.class);
    public static final String CONFIG_KEY_PREFIX = "sdloader.";
    public static final String KEY_SDLOADER_JSP_LIBPATH = "sdloader.jsp.libpath";
    public static final String KEY_SDLOADER_HOME = "sdloader.home";
    public static final String KEY_SDLOADER_WEBAPP_PATH = "sdloader.webAppPath";
    public static final String KEY_WAR_INMEMORY_EXTRACT = "sdloader.warInMemoryExtract";
    public static final String KEY_SDLOADER_USE_OUTSIDE_PORT = "sdloader.useOutSidePort";
    public static final String KEY_SDLOADER_MAX_THREAD_POOL_NUM = "sdloader.maxThreadPoolNum";
    public static final String KEY_SDLOADER_AUTO_PORT_DETECT = "sdloader.autoPortDetect";
    public static final String KEY_SDLOADER_SERVER_NAME = "sdloader.serverName";
    public static final String KEY_SDLOADER_SESSION_MANAGER = "sdloader.sessionManager";
    public static final String KEY_SDLOADER_LINE_SPEED = "sdloader.lineSpeed";
    public static final String KEY_SDLOADER_PORT = "sdloader.port";
    public static final String KEY_SDLOADER_WORK_DIR = "sdloader.workDir";
    private String sdloaderConfigPath = "sdloader.properties";
    protected WebAppManager webAppManager = new WebAppManager();
    protected SDLoaderConfig config = new SDLoaderConfig();
    protected EventDispatcher<LifecycleListener, LifecycleEvent<SDLoader>> dispatcher = new EventDispatcher(LifecycleListener.class);
    public boolean running = false;
    private HttpProcessorPool socketProcessorPool;
    private SessionManager sessionManager;
    private SDLoaderThread sdLoaderThread;

    public SDLoader() {
        this.loadDefaultConfig();
    }

    public SDLoader(int port) {
        this.loadDefaultConfig();
        this.setPort(port);
    }

    public SDLoader(boolean autoPortDetect) {
        this.loadDefaultConfig();
        this.setAutoPortDetect(autoPortDetect);
    }

    public SDLoader(String defaultConfigPath) {
        this.sdloaderConfigPath = defaultConfigPath;
        this.loadDefaultConfig();
    }

    protected void loadDefaultConfig() {
        Properties initSetting = ResourceUtil.loadProperties(this.sdloaderConfigPath, SDLoader.class);
        this.config.addAllIfNotExist(initSetting);
    }

    public void setConfig(String key, String value) {
        this.getSDLoaderConfig().setConfig(key, value);
    }

    public SDLoaderConfig getSDLoaderConfig() {
        return this.config;
    }

    public void setAutoPortDetect(boolean autoPortDetect) {
        this.checkNotRunning();
        this.config.setConfig(KEY_SDLOADER_AUTO_PORT_DETECT, autoPortDetect);
    }

    public void setUseOutSidePort(boolean useOutSizePort) {
        this.checkNotRunning();
        this.config.setConfig(KEY_SDLOADER_USE_OUTSIDE_PORT, Boolean.toString(useOutSizePort));
    }

    public void setMaxThreadPoolNum(int maxThreadPoolNum) {
        this.checkNotRunning();
        this.config.setConfig(KEY_SDLOADER_MAX_THREAD_POOL_NUM, maxThreadPoolNum);
    }

    public void setURIEncoding(String uriEncoding) {
        this.checkNotRunning();
        this.config.setConfig("sdloader.request.URIEncoding", uriEncoding);
    }

    public void setUseBodyEncodingURI(boolean useBodyEncodingForURI) {
        this.checkNotRunning();
        this.config.setConfig("sdloader.request.useBodyEncodingURI", useBodyEncodingForURI);
    }

    public void setUseNoCacheMode(boolean useNoCacheMode) {
        this.checkNotRunning();
        this.config.setConfig("sdloader.response.useNoCacheMode", useNoCacheMode);
    }

    public void setPort(int port) {
        this.checkNotRunning();
        this.config.setConfig(KEY_SDLOADER_PORT, port);
    }

    public void setServerName(String serverName) {
        this.checkNotRunning();
        this.config.setConfig(KEY_SDLOADER_SERVER_NAME, serverName);
    }

    public void setLineSpeed(int bps) {
        this.checkNotRunning();
        this.config.setConfig(KEY_SDLOADER_LINE_SPEED, bps);
    }

    public void setWorkDir(String workDir) {
        this.checkNotRunning();
        this.config.setConfig(KEY_SDLOADER_WORK_DIR, workDir);
    }

    public void addWebAppContext(WebAppContext context) {
        this.checkNotRunning();
        this.webAppManager.addWebAppContext(context);
    }

    public int getPort() {
        return this.config.getConfigInteger(KEY_SDLOADER_PORT);
    }

    public String getServerName() {
        return this.config.getConfigString(KEY_SDLOADER_SERVER_NAME);
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public static String getVersion() {
        try {
            InputStream is = SDLoader.class.getResourceAsStream("/META-INF/sdloaderversion.txt");
            Properties p = new Properties();
            p.load(is);
            return p.getProperty("libversion");
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public void addEventListener(String type, LifecycleListener listener) {
        this.dispatcher.addEventListener(type, listener);
    }

    public boolean isRunning() {
        return this.running;
    }

    public void start() {
        this.checkNotRunning();
        this.running = true;
        log.info("Detect ServletAPI[" + JavaEEConstants.SERVLETAPI_MAJOR_VERSION + "." + JavaEEConstants.SERVLETAPI_MINOR_VERSION + "] JSP[" + JavaEEConstants.JSP_MAJOR_VERSION + "." + JavaEEConstants.JSP_MINOR_VERSION + "]");
        long t = System.currentTimeMillis();
        this.dispatcher.dispatchEvent(new LifecycleEvent<SDLoader>("BEFORE_START", this));
        this.initConfig();
        this.initSessionManager();
        ServerSocket initSocket = this.initServerSocket();
        this.initWebApp();
        this.initSocketProcessor();
        this.initShutdownHook();
        this.sdLoaderThread = new SDLoaderThread(initSocket);
        this.sdLoaderThread.start();
        log.info("SDLoader[port:" + this.getPort() + "] startup in " + (System.currentTimeMillis() - t) + " ms.");
        this.dispatcher.dispatchEvent(new LifecycleEvent<SDLoader>("AFTER_START", this));
    }

    public synchronized void stop() {
        if (!this.running) {
            return;
        }
        log.info("SDLoader[port:" + this.getPort() + "] shutdown start.");
        this.dispatcher.dispatchEvent(new LifecycleEvent<SDLoader>("BEFORE_STOP", this));
        this.webAppManager.close();
        this.socketProcessorPool.stop();
        this.sdLoaderThread.close();
        this.running = false;
        this.dispatcher.dispatchEvent(new LifecycleEvent<SDLoader>("AFTER_STOP", this));
        log.info("SDLoader[port:" + this.getPort() + "] stop.");
    }

    public void waitForStop() {
        if (this.running) {
            try {
                this.sdLoaderThread.join();
            }
            catch (InterruptedException e) {
                log.error(e.getMessage(), e);
            }
        }
    }

    protected void initConfig() {
        String homeDir = this.config.getConfigStringIgnoreExist(KEY_SDLOADER_HOME);
        if (homeDir == null && (homeDir = System.getProperty(KEY_SDLOADER_HOME)) == null) {
            homeDir = System.getProperty("user.dir");
        }
        homeDir = PathUtil.replaceFileSeparator(homeDir);
        homeDir = PathUtil.removeEndSlashIfNeed(homeDir);
        this.config.setConfig(KEY_SDLOADER_HOME, homeDir);
        log.info("SDLOADER_HOME=" + homeDir);
        String webappPath = this.config.getConfigStringIgnoreExist(KEY_SDLOADER_WEBAPP_PATH);
        if (webappPath == null && (webappPath = System.getProperty(KEY_SDLOADER_WEBAPP_PATH)) == null) {
            webappPath = "webapps";
        }
        if (!PathUtil.isAbsolutePath(webappPath = PathUtil.replaceFileSeparator(webappPath))) {
            webappPath = homeDir + "/" + webappPath;
        }
        this.config.setConfig(KEY_SDLOADER_WEBAPP_PATH, webappPath);
        log.info("sdloader.webAppPath=" + webappPath);
        this.config.setConfigFromSystemIfNotExit(KEY_SDLOADER_JSP_LIBPATH);
        String workDir = this.config.getConfigStringIgnoreExist(KEY_SDLOADER_WORK_DIR);
        if (workDir == null) {
            workDir = System.getProperty("java.io.tmpdir") + "/.sdloader";
        }
        this.config.setConfig(KEY_SDLOADER_WORK_DIR, workDir);
    }

    protected void initSessionManager() {
        String sessionManagerClassName = this.config.getConfigString(KEY_SDLOADER_SESSION_MANAGER);
        this.sessionManager = (SessionManager)ClassUtil.newInstance(sessionManagerClassName);
    }

    protected void initWebApp() {
        try {
            log.info("InternalWebApplication initialize start.");
            this.webAppManager.init(this.config);
            log.info("InternalWebApplication initialize success.");
        }
        catch (RuntimeException e) {
            log.error("InternalWebApplication initialize fail.", e);
            throw e;
        }
    }

    protected ServerSocket initServerSocket() {
        boolean useOutSidePort = this.config.getConfigBoolean(KEY_SDLOADER_USE_OUTSIDE_PORT);
        boolean autoPortDetect = this.config.getConfigBoolean(KEY_SDLOADER_AUTO_PORT_DETECT);
        int port = this.getPort();
        String portMessage = autoPortDetect ? "AutoDetect" : String.valueOf(port);
        log.info("Bind start. Port=" + portMessage + " useOutSidePort=" + useOutSidePort);
        ServerSocket servetSocket = null;
        try {
            try {
                int bindPort = this.getPort();
                servetSocket = IOUtil.createServerSocket(bindPort, useOutSidePort);
            }
            catch (IOException ioe) {
                if (autoPortDetect) {
                    servetSocket = IOUtil.createServerSocket(0, useOutSidePort);
                }
                throw ioe;
            }
            int bindSuccessPort = servetSocket.getLocalPort();
            this.config.setConfig(KEY_SDLOADER_PORT, bindSuccessPort);
            log.info("Bind success. Port=" + this.getPort());
        }
        catch (IOException ioe) {
            log.error("Bind fail! Port=" + portMessage, ioe);
            throw new RuntimeException(ioe);
        }
        return servetSocket;
    }

    protected void initSocketProcessor() {
        int maxThreadPoolNum = this.config.getConfigInteger(KEY_SDLOADER_MAX_THREAD_POOL_NUM);
        this.socketProcessorPool = new HttpProcessorPool(maxThreadPoolNum);
    }

    protected void initShutdownHook() {
        final SDLoader sdloader = this;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    sdloader.stop();
                }
                catch (Throwable e) {
                    log.error("SDLoader close fail.", e);
                }
                finally {
                    DisposableUtil.dispose();
                }
            }
        });
    }

    protected boolean checkNotRunning() {
        if (this.running) {
            throw new IllegalStateException("SDLoader is already running.");
        }
        return false;
    }

    public WebAppManager getWebAppManager() {
        return this.webAppManager;
    }

    public void returnProcessor(HttpProcessor processor) {
        this.socketProcessorPool.returnProcessor(processor);
    }

    class SDLoaderThread
    extends Thread {
        private boolean shutdown;
        private ServerSocket serverSocket;

        SDLoaderThread(ServerSocket serverSocket) {
            super("SDLoaderThread");
            this.shutdown = false;
            this.serverSocket = serverSocket;
            this.setDaemon(false);
        }

        public void run() {
            while (!this.shutdown) {
                Socket socket = null;
                try {
                    socket = this.serverSocket.accept();
                    log.debug("Accept socket connection.");
                }
                catch (AccessControlException ace) {
                    log.warn("Socket accept security exception " + ace.getMessage(), ace);
                    continue;
                }
                catch (IOException ioe) {
                    if (this.shutdown) break;
                    log.error("Socket accept error.", ioe);
                    continue;
                }
                HttpProcessor con = SDLoader.this.socketProcessorPool.borrowProcessor();
                con.process(socket, SDLoader.this);
            }
        }

        public synchronized void close() {
            if (this.serverSocket != null) {
                IOUtil.closeServerSocketNoException(this.serverSocket);
                this.serverSocket = null;
            }
            this.shutdown = true;
        }
    }
}

