/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TF_DISPLAYATTRIBUTE;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public class IME
extends Widget {
    Canvas parent;
    int caretOffset;
    int startOffset;
    int commitCount;
    String text;
    int[] ranges;
    TextStyle[] styles;
    static final int WM_MSIME_MOUSE = OS.RegisterWindowMessage(new TCHAR(0, "MSIMEMouseOperation", true));
    static final byte[] IID_ITfInputProcessorProfiles = new byte[16];
    static final byte[] IID_ITfDisplayAttributeProvider = new byte[16];
    static final byte[] CLSID_TF_InputProcessorProfiles = new byte[16];
    static final byte[] GUID_TFCAT_TIP_KEYBOARD = new byte[16];
    static final int UNDERLINE_IME_DOT = 65536;
    static final int UNDERLINE_IME_DASH = 131072;
    static final int UNDERLINE_IME_THICK = 196608;

    static {
        OS.IIDFromString("{1F02B6C5-7842-4EE6-8A0B-9A24183A95CA}\u0000".toCharArray(), IID_ITfInputProcessorProfiles);
        OS.IIDFromString("{fee47777-163c-4769-996a-6e9c50ad8f54}\u0000".toCharArray(), IID_ITfDisplayAttributeProvider);
        OS.IIDFromString("{33C53A50-F456-4884-B049-85FD643ECFED}\u0000".toCharArray(), CLSID_TF_InputProcessorProfiles);
        OS.IIDFromString("{34745C63-B2F0-4784-8B67-5E12C8701A31}\u0000".toCharArray(), GUID_TFCAT_TIP_KEYBOARD);
    }

    IME() {
    }

    public IME(Canvas canvas, int n) {
        super(canvas, n);
        this.parent = canvas;
        this.createWidget();
    }

    void createWidget() {
        this.text = "";
        this.startOffset = -1;
        if (this.parent.getIME() == null) {
            this.parent.setIME(this);
        }
    }

    public int getCaretOffset() {
        this.checkWidget();
        return this.startOffset + this.caretOffset;
    }

    public int getCommitCount() {
        this.checkWidget();
        return this.commitCount;
    }

    public int getCompositionOffset() {
        this.checkWidget();
        return this.startOffset;
    }

    TF_DISPLAYATTRIBUTE getDisplayAttribute(short s, int n) {
        int[] nArray = new int[1];
        int n2 = OS.CoCreateInstance(CLSID_TF_InputProcessorProfiles, 0, 1, IID_ITfInputProcessorProfiles, nArray);
        TF_DISPLAYATTRIBUTE tF_DISPLAYATTRIBUTE = null;
        if (n2 == 0) {
            int[] nArray2;
            byte[] byArray = new byte[16];
            byte[] byArray2 = new byte[16];
            n2 = OS.VtblCall(8, nArray[0], s, GUID_TFCAT_TIP_KEYBOARD, byArray, byArray2);
            if (n2 == 0 && (n2 = OS.CoCreateInstance(byArray, 0, 1, IID_ITfDisplayAttributeProvider, nArray2 = new int[1])) == 0) {
                int[] nArray3 = new int[1];
                n2 = OS.VtblCall(3, nArray2[0], nArray3);
                if (n2 == 0) {
                    int[] nArray4 = new int[1];
                    TF_DISPLAYATTRIBUTE tF_DISPLAYATTRIBUTE2 = new TF_DISPLAYATTRIBUTE();
                    while ((n2 = OS.VtblCall(4, nArray3[0], 1, nArray4, null)) == 0) {
                        OS.VtblCall(5, nArray4[0], tF_DISPLAYATTRIBUTE2);
                        OS.VtblCall(2, nArray4[0]);
                        if (tF_DISPLAYATTRIBUTE2.bAttr != n) continue;
                        tF_DISPLAYATTRIBUTE = tF_DISPLAYATTRIBUTE2;
                        break;
                    }
                    n2 = OS.VtblCall(2, nArray3[0]);
                }
                n2 = OS.VtblCall(2, nArray2[0]);
            }
            n2 = OS.VtblCall(2, nArray[0]);
        }
        if (tF_DISPLAYATTRIBUTE == null) {
            tF_DISPLAYATTRIBUTE = new TF_DISPLAYATTRIBUTE();
            switch (n) {
                case 0: {
                    tF_DISPLAYATTRIBUTE.lsStyle = 4;
                    break;
                }
                case 1: 
                case 2: {
                    tF_DISPLAYATTRIBUTE.lsStyle = 1;
                    tF_DISPLAYATTRIBUTE.fBoldLine = n == 1;
                }
            }
        }
        return tF_DISPLAYATTRIBUTE;
    }

    public int[] getRanges() {
        this.checkWidget();
        if (this.ranges == null) {
            return new int[0];
        }
        int[] nArray = new int[this.ranges.length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this.ranges[n] + this.startOffset;
            ++n;
        }
        return nArray;
    }

    public TextStyle[] getStyles() {
        this.checkWidget();
        if (this.styles == null) {
            return new TextStyle[0];
        }
        TextStyle[] textStyleArray = new TextStyle[this.styles.length];
        System.arraycopy(this.styles, 0, textStyleArray, 0, this.styles.length);
        return textStyleArray;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public boolean getWideCaret() {
        this.checkWidget();
        int n = OS.GetKeyboardLayout(0);
        short s = (short)OS.LOWORD(n);
        return OS.PRIMARYLANGID(s) == 18;
    }

    boolean isInlineEnabled() {
        if (OS.IsWinCE || OS.WIN32_VERSION < OS.VERSION(5, 1)) {
            return false;
        }
        return OS.IsDBLocale && this.hooks(43);
    }

    void releaseParent() {
        super.releaseParent();
        if (this == this.parent.getIME()) {
            this.parent.setIME(null);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.text = null;
        this.styles = null;
        this.ranges = null;
    }

    public void setCompositionOffset(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        if (this.startOffset != -1) {
            this.startOffset = n;
        }
    }

    LRESULT WM_IME_COMPOSITION(int n, int n2) {
        if (!this.isInlineEnabled()) {
            return null;
        }
        this.ranges = null;
        this.styles = null;
        this.commitCount = 0;
        this.caretOffset = 0;
        int n3 = this.parent.handle;
        int n4 = OS.ImmGetContext(n3);
        int n5 = this.parent.getCodePage();
        if (n4 != 0) {
            short s;
            Object object;
            Object object2;
            int n6;
            TCHAR tCHAR = null;
            if ((n2 & 0x800) != 0) {
                n6 = OS.ImmGetCompositionString(n4, 2048, null, 0);
                if (n6 > 0) {
                    tCHAR = new TCHAR(n5, n6 / TCHAR.sizeof);
                    OS.ImmGetCompositionString(n4, 2048, tCHAR, n6);
                    if (this.startOffset == -1) {
                        object2 = new Event();
                        ((Event)object2).detail = 3;
                        this.sendEvent(43, (Event)object2);
                        this.startOffset = ((Event)object2).start;
                    }
                    object2 = new Event();
                    ((Event)object2).detail = 1;
                    ((Event)object2).start = this.startOffset;
                    ((Event)object2).end = this.startOffset + this.text.length();
                    this.text = tCHAR != null ? tCHAR.toString() : "";
                    ((Event)object2).text = this.text;
                    this.commitCount = this.text.length();
                    this.sendEvent(43, (Event)object2);
                    object = this.text;
                    this.text = "";
                    this.startOffset = -1;
                    this.commitCount = 0;
                    if (((Event)object2).doit) {
                        Display display = this.display;
                        display.lastKey = 0;
                        display.lastDead = false;
                        display.lastNull = false;
                        display.lastVirtual = false;
                        n6 = ((String)object).length();
                        s = 0;
                        while (s < n6) {
                            char c = ((String)object).charAt(s);
                            display.lastAscii = c;
                            object2 = new Event();
                            ((Event)object2).character = c;
                            this.parent.sendEvent(1, (Event)object2);
                            ++s;
                        }
                    }
                }
                if ((n2 & 8) == 0) {
                    return LRESULT.ONE;
                }
            }
            tCHAR = null;
            if ((n2 & 8) != 0) {
                n6 = OS.ImmGetCompositionString(n4, 8, null, 0);
                if (n6 > 0) {
                    tCHAR = new TCHAR(n5, n6 / TCHAR.sizeof);
                    OS.ImmGetCompositionString(n4, 8, tCHAR, n6);
                    if ((n2 & 0x80) != 0) {
                        this.caretOffset = OS.ImmGetCompositionString(n4, 128, null, 0);
                    }
                    object2 = null;
                    if ((n2 & 0x20) != 0 && (n6 = OS.ImmGetCompositionStringW(n4, 32, null, 0)) > 0) {
                        object2 = new int[n6 / 4];
                        OS.ImmGetCompositionStringW(n4, 32, (int[])object2, n6);
                    }
                    if ((n2 & 0x10) != 0 && object2 != null && (n6 = OS.ImmGetCompositionStringA(n4, 16, null, 0)) > 0) {
                        object = new byte[n6];
                        OS.ImmGetCompositionStringA(n4, 16, (byte[])object, n6);
                        n6 = ((Object)object2).length - 1;
                        this.ranges = new int[n6 * 2];
                        this.styles = new TextStyle[n6];
                        int n7 = OS.GetKeyboardLayout(0);
                        s = (short)OS.LOWORD(n7);
                        TF_DISPLAYATTRIBUTE tF_DISPLAYATTRIBUTE = null;
                        TextStyle textStyle = null;
                        int n8 = 0;
                        while (n8 < n6) {
                            this.ranges[n8 * 2] = (int)object2[n8];
                            this.ranges[n8 * 2 + 1] = (int)(object2[n8 + 1] - true);
                            this.styles[n8] = textStyle = new TextStyle();
                            tF_DISPLAYATTRIBUTE = this.getDisplayAttribute(s, (int)object[object2[n8]]);
                            if (tF_DISPLAYATTRIBUTE != null) {
                                int n9;
                                switch (tF_DISPLAYATTRIBUTE.crText.type) {
                                    case 2: {
                                        textStyle.foreground = Color.win32_new(this.display, tF_DISPLAYATTRIBUTE.crText.cr);
                                        break;
                                    }
                                    case 1: {
                                        n9 = OS.GetSysColor(tF_DISPLAYATTRIBUTE.crText.cr);
                                        textStyle.foreground = Color.win32_new(this.display, n9);
                                    }
                                }
                                switch (tF_DISPLAYATTRIBUTE.crBk.type) {
                                    case 2: {
                                        textStyle.background = Color.win32_new(this.display, tF_DISPLAYATTRIBUTE.crBk.cr);
                                        break;
                                    }
                                    case 1: {
                                        n9 = OS.GetSysColor(tF_DISPLAYATTRIBUTE.crBk.cr);
                                        textStyle.background = Color.win32_new(this.display, n9);
                                    }
                                }
                                switch (tF_DISPLAYATTRIBUTE.crLine.type) {
                                    case 2: {
                                        textStyle.underlineColor = Color.win32_new(this.display, tF_DISPLAYATTRIBUTE.crLine.cr);
                                        break;
                                    }
                                    case 1: {
                                        n9 = OS.GetSysColor(tF_DISPLAYATTRIBUTE.crLine.cr);
                                        textStyle.underlineColor = Color.win32_new(this.display, n9);
                                    }
                                }
                                textStyle.underline = tF_DISPLAYATTRIBUTE.lsStyle != 0;
                                switch (tF_DISPLAYATTRIBUTE.lsStyle) {
                                    case 4: {
                                        textStyle.underlineStyle = 3;
                                        break;
                                    }
                                    case 3: {
                                        textStyle.underlineStyle = 131072;
                                        break;
                                    }
                                    case 2: {
                                        textStyle.underlineStyle = 65536;
                                        break;
                                    }
                                    case 1: {
                                        textStyle.underlineStyle = tF_DISPLAYATTRIBUTE.fBoldLine ? 196608 : 0;
                                    }
                                }
                            }
                            ++n8;
                        }
                    }
                }
                OS.ImmReleaseContext(n3, n4);
            }
            n6 = this.startOffset + this.text.length();
            if (this.startOffset == -1) {
                object2 = new Event();
                ((Event)object2).detail = 3;
                this.sendEvent(43, (Event)object2);
                this.startOffset = ((Event)object2).start;
                n6 = ((Event)object2).end;
            }
            object2 = new Event();
            ((Event)object2).detail = 1;
            ((Event)object2).start = this.startOffset;
            ((Event)object2).end = n6;
            this.text = tCHAR != null ? tCHAR.toString() : "";
            ((Event)object2).text = this.text;
            this.sendEvent(43, (Event)object2);
            if (this.text.length() == 0) {
                this.startOffset = -1;
                this.ranges = null;
                this.styles = null;
            }
        }
        return LRESULT.ONE;
    }

    LRESULT WM_IME_COMPOSITION_START(int n, int n2) {
        return this.isInlineEnabled() ? LRESULT.ONE : null;
    }

    LRESULT WM_IME_ENDCOMPOSITION(int n, int n2) {
        return this.isInlineEnabled() ? LRESULT.ONE : null;
    }

    LRESULT WM_KILLFOCUS(int n, int n2) {
        if (!this.isInlineEnabled()) {
            return null;
        }
        int n3 = this.parent.handle;
        int n4 = OS.ImmGetContext(n3);
        if (n4 != 0) {
            if (OS.ImmGetOpenStatus(n4)) {
                OS.ImmNotifyIME(n4, 21, 1, 0);
            }
            OS.ImmReleaseContext(n3, n4);
        }
        return null;
    }

    LRESULT WM_LBUTTONDOWN(int n, int n2) {
        if (!this.isInlineEnabled()) {
            return null;
        }
        int n3 = this.parent.handle;
        int n4 = OS.ImmGetContext(n3);
        if (n4 != 0) {
            if (OS.ImmGetOpenStatus(n4) && OS.ImmGetCompositionString(n4, 8, null, 0) > 0) {
                Event event = new Event();
                event.detail = 2;
                event.x = OS.GET_X_LPARAM(n2);
                event.y = OS.GET_Y_LPARAM(n2);
                this.sendEvent(43, event);
                int n5 = event.index;
                int n6 = this.text.length();
                if (n5 != -1 && this.startOffset != -1 && this.startOffset <= n5 && n5 < this.startOffset + n6) {
                    int n7 = OS.ImmGetDefaultIMEWnd(n3);
                    n5 = event.index + event.count - this.startOffset;
                    int n8 = event.count > 0 ? 1 : 2;
                    int n9 = OS.MAKEWPARAM(OS.MAKEWORD(1, n8), n5);
                    OS.SendMessage(n7, WM_MSIME_MOUSE, n9, n4);
                } else {
                    OS.ImmNotifyIME(n4, 21, 1, 0);
                }
            }
            OS.ImmReleaseContext(n3, n4);
        }
        return null;
    }
}

