package org.t2framework.util.impl;

import org.t2framework.util.UrlTemplate;
import org.t2framework.util.UrlTemplateFactory;

import commons.util.Assertion;
import commons.util.StringUtil;

public class UrlTemplateFactoryImpl implements UrlTemplateFactory {

	@Override
	public UrlTemplate getUrlTemplate(final String templatePath) {
		return createTemplate(Assertion.notNull(templatePath));
	}

	@Override
	public UrlTemplate getUrlTemplate(final String prefix,
			final String templatePath) {
		Assertion.notNull(prefix);
		Assertion.notNull(templatePath);
		String path = templatePath;
		String pref = prefix;
		if (!StringUtil.isEmpty(pref)
				&& prefix.lastIndexOf('/') == prefix.length() - 1) {
			pref = pref.substring(0, pref.length() - 1);
		}
		String tempPath = templatePath;
		if (tempPath.indexOf('/') == 0) {
			tempPath = tempPath.substring(1, tempPath.length());
		}
		path = pref + "/" + tempPath;
		return createTemplate(path);
	}

	protected UrlTemplate createTemplate(final String templatePath) {
		return new UrlTemplateImpl(Assertion.notNull(templatePath));
	}

}
