package org.t2framework.util;

import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

import commons.annotation.Published;
import commons.util.PatternUtil;

/**
 * UrlTemplate is a template class to parse the expression of url for T2.
 * 
 * @author shot
 */
public interface UrlTemplate {

	Pattern TEMPLATE_PATTERN = PatternUtil.getPattern("([{]([^}]+)[}])([^{]*)");

	String ACCEPTABLE_STR = "([a-zA-Z0-9!\\|\\-\\_\\^\\$\\.\\*\\+'\\(\\)\\,]+)";

	String ESCAPED_CHARS = "\\[].^$?*+()|,:<>=";

	/**
	 * Return true if the given parameter and template url-pattern matched.
	 * 
	 * @param urlPath
	 * @return
	 */
	@Published
	boolean match(String urlPath);

	/**
	 * Parse given parameter and retutn map of template-key and actual value.
	 * 
	 * @param urlPath
	 * @return
	 */
	@Published
	Map<String, String> parseUrl(String urlPath);

	/**
	 * Return list of url patterns.
	 * 
	 * @return
	 */
	@Published
	List<Pattern> getUrlPattern();

	/**
	 * Bind by given parameter map.
	 * 
	 * Consider {@code &quot;/hoge/ foo}/{bar}&quot;} is given.<br /> And
	 * bindByName method is called with the parameter map like :<br /> {@code
	 * map.put("foo", "A");}<br /> {@code map.put("bar", "B");}.<br /> The
	 * result is {@code /hoge/A/B}.
	 * 
	 * @param parameters
	 * @return
	 */
	String bindByName(Map<String, String> parameters);

	/**
	 * Bind given parameters by given order.
	 * 
	 * @param values
	 * @return string : binded result.
	 */
	String bindByPosition(String... values);

	/**
	 * Get list of expression names.
	 * 
	 * @return list of expression names
	 */
	List<String> getExpressionNames();

	/**
	 * Get template path.
	 * 
	 * @return string : template path
	 */
	String getTemplatePath();
}
