package org.t2framework.util;

import javax.servlet.http.HttpServletRequest;

import org.t2framework.contexts.Request;

import commons.util.Assertion;
import commons.util.StringUtil;

/**
 * PathUtil is an utility class for creating path. This class is expected to use
 * internally.
 * 
 * @author shot
 */
public class PathUtil {

	public static String getPagePath(Request request) {
		final HttpServletRequest req = request.getNativeResource();
		String requestUri = req.getRequestURI();
		String contextPath = req.getContextPath();
		int index = requestUri.indexOf(contextPath);
		String path = null;
		if (index >= 0) {
			path = requestUri.substring(index + contextPath.length(),
					requestUri.length());
		} else {
			path = requestUri;
		}
		return (startsWithSlash(path)) ? path.substring(1) : path;
	}

	public static String getActionMethodDescPath(final Request request,
			final String pagePath) {
		Assertion.notNull(pagePath);
		final String path = getPagePath(request);
		String testPath = (startsWithSlash(pagePath)) ? pagePath.substring(1)
				: pagePath;
		if (path.indexOf(testPath) == 0) {
			return path.substring(testPath.length(), path.length());
		} else {
			return path;
		}
	}

	public static boolean startsWithSlash(final String s) {
		if (StringUtil.isEmpty(s)) {
			return false;
		}
		return s.indexOf("/") == 0;
	}

	public static boolean endsWithSlash(final String s) {
		if (StringUtil.isEmpty(s)) {
			return false;
		}
		return s.lastIndexOf("/") == s.length() - 1;
	}

}