package org.t2framework.tag;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

import javax.servlet.http.HttpServletRequest;

import org.t2framework.contexts.WebContext;

import commons.util.DateUtil;
import commons.util.HtmlEscapeUtil;
import commons.util.URLUtil;

/**
 * Functions is an utility class to be expected to use from JSP. To use
 * function, JSP2.0 spec or higher is required.
 * 
 * @author shot
 */
public class Functions {

	/**
	 * Output object.
	 * 
	 * @param o
	 * @return
	 */
	public static String out(Object o) {
		return (o != null) ? escape(o) : "";
	}

	/**
	 * Format to date.As default, pattern sets as yyyy/MM/DD.
	 * 
	 * @param date
	 * @return
	 */
	public static String dateFormat(Date date) {
		if (date == null) {
			return null;
		}
		String pattern = DateUtil.findPattern(WebContext.get()
				.getRequestLocale());
		return dateFormatWith(date, pattern);
	}

	/**
	 * Format to date with specifed pattern.
	 * 
	 * @param date
	 * @param pattern
	 * @return
	 */
	public static String dateFormatWith(Date date, String pattern) {
		if (date == null) {
			return null;
		}
		final SimpleDateFormat formatter = new SimpleDateFormat(pattern);
		return formatter.format(date);
	}

	/**
	 * Append context-path to given parameter.
	 * 
	 * @param orgurl
	 * @return
	 */
	public static String url(String orgurl) {
		if (URLUtil.isAbsoluteUrl(orgurl)) {
			return orgurl;
		}
		WebContext context = WebContext.get();
		if (context == null) {
			return orgurl;
		}
		HttpServletRequest request = context.getRequest().getNativeResource();
		if (request == null) {
			return orgurl;
		}
		String url = "";
		final String contextPath = request.getContextPath();
		if (orgurl.indexOf(contextPath) == 0) {
			url = orgurl;
		} else {
			if (!contextPath.endsWith("/") && !orgurl.startsWith("/")) {
				url = contextPath + "/" + orgurl;
			} else {
				url = contextPath + orgurl;
			}
		}
		if (request.isRequestedSessionIdFromCookie()) {
			return url;
		} else {
			return context.getResponse().getNativeResource().encodeURL(url);
		}
	}

	/**
	 * Escape object.
	 * 
	 * @param input
	 * @return
	 */
	public static String escape(Object input) {
		if (input == null) {
			return "";
		}
		String s = "";
		if (input.getClass().isArray()) {
			s = convertFromArray(input);
		} else {
			s = input.toString();
		}
		return escape(s);
	}

	/**
	 * Escape string.
	 * 
	 * @param s
	 * @return
	 */
	public static String escape(String s) {
		return HtmlEscapeUtil.escape(s);
	}

	private static String convertFromArray(Object input) {
		Class<?> clazz = input.getClass().getComponentType();
		String s = "";
		if (clazz == String.class) {
			s = Arrays.toString((Object[]) input);
		} else if (clazz == boolean.class) {
			s = Arrays.toString((boolean[]) input);
		} else if (clazz == int.class) {
			s = Arrays.toString((int[]) input);
		} else if (clazz == long.class) {
			s = Arrays.toString((long[]) input);
		} else if (clazz == byte.class) {
			s = Arrays.toString((byte[]) input);
		} else if (clazz == short.class) {
			s = Arrays.toString((short[]) input);
		} else if (clazz == float.class) {
			s = Arrays.toString((float[]) input);
		} else if (clazz == double.class) {
			s = Arrays.toString((double[]) input);
		} else if (clazz == char.class) {
			s = Arrays.toString((char[]) input);
		} else {
			s = Arrays.toString((Object[]) input);
		}
		return s;
	}
}
