package org.t2framework.spi.impl;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.t2framework.action.ActionAnnotationResolver;
import org.t2framework.action.ParameterResolver;
import org.t2framework.action.impl.ActionParamAnnotationResolver;
import org.t2framework.action.impl.ActionPathAnnotationResolver;
import org.t2framework.action.impl.DefaultAnnotationResolver;
import org.t2framework.action.impl.HttpMethodActionAnnotationResolver;
import org.t2framework.action.impl.HttpServletRequestParameterResolver;
import org.t2framework.action.impl.HttpServletResponseParameterResolver;
import org.t2framework.action.impl.HttpSessionParameterResolver;
import org.t2framework.action.impl.ServletContextParameterResolver;
import org.t2framework.action.impl.WebContextParameterResolver;
import org.t2framework.adapter.ContainerAdapter;
import org.t2framework.annotation.composite.GET;
import org.t2framework.annotation.composite.POST;
import org.t2framework.annotation.core.ActionParam;
import org.t2framework.annotation.core.ActionPath;
import org.t2framework.contexts.HttpMethod;
import org.t2framework.contexts.WebContext;
import org.t2framework.spi.AnnotationResolverCreator;

import commons.util.CollectionsUtil;

public class DefaultAnnotationResolverCreatorImpl implements
		AnnotationResolverCreator {

	protected static List<ParameterResolver> parameterResolvers = CollectionsUtil
			.newArrayList();

	protected static Map<Class<? extends Annotation>, ActionAnnotationResolver> actionAnnotationResolverMap = CollectionsUtil
			.newHashMap();

	protected static ActionAnnotationResolver defaultAnnotationResolver = new DefaultAnnotationResolver();
	static {
		parameterResolvers.add(new WebContextParameterResolver());
		parameterResolvers.add(new HttpServletRequestParameterResolver());
		parameterResolvers.add(new HttpServletResponseParameterResolver());
		parameterResolvers.add(new HttpSessionParameterResolver());
		parameterResolvers.add(new ServletContextParameterResolver());

		actionAnnotationResolverMap.put(GET.class,
				new HttpMethodActionAnnotationResolver(HttpMethod.GET));
		actionAnnotationResolverMap.put(POST.class,
				new HttpMethodActionAnnotationResolver(HttpMethod.POST));
		actionAnnotationResolverMap.put(ActionPath.class,
				new ActionPathAnnotationResolver());
		actionAnnotationResolverMap.put(ActionParam.class,
				new ActionParamAnnotationResolver());
	};

	@Override
	public Map<Class<? extends Annotation>, ActionAnnotationResolver> createActionAnnotationResolvers(
			ContainerAdapter<?> containerAdapter) {
		return actionAnnotationResolverMap;
	}

	@Override
	public ActionAnnotationResolver createDefaultActionAnnotationResolver(
			ContainerAdapter<?> containerAdapter) {
		return defaultAnnotationResolver;
	}

	@Override
	public List<ParameterResolver> createParameterResolvers(
			ContainerAdapter<?> containerAdapter, WebContext context) {
		return parameterResolvers;
	}

	@Override
	public Set<Class<? extends Annotation>> getActionAnnotationSet(
			ContainerAdapter<?> containerAdapter) {
		return actionAnnotationResolverMap.keySet();
	}

}
