package org.t2framework.spi;

import org.t2framework.contexts.WebContext;

import commons.annotation.Published;

/**
 * Navigation is an interface to notify where next transition goes. You can
 * create your own Navigation concrete class so that's why we put it on
 * org.t2framework.spi package!
 * 
 * @author shot
 */
@Published
public interface Navigation {

	/**
	 * Execute navigation processing.
	 * 
	 * @param context
	 * @throws Exception
	 */
	void execute(WebContext context) throws Exception;

}
