package org.t2framework.spi;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.t2framework.action.ActionAnnotationResolver;
import org.t2framework.action.ParameterResolver;
import org.t2framework.adapter.ContainerAdapter;
import org.t2framework.contexts.WebContext;

/**
 * AnnotationResolverCreator is an interface to map annotation and its handler
 * for processing method annotation and parameter annotation. This is the
 * extension point to use with ServiceLoader. You can add
 * /META-INF/services/org.t2framework.spi.AnnotationResolverCreator file and
 * write your own AnnotationResolverCreator implementation.
 * 
 * @author shot
 */
public interface AnnotationResolverCreator {

	/**
	 * Create list of ParameterResolver, which is a class to handle how to
	 * behave if the specified parameter annotation is annotated.
	 * 
	 * @param containerAdapter
	 *            : IoC container adapter
	 * @param context
	 * @return
	 */
	List<ParameterResolver> createParameterResolvers(
			ContainerAdapter<?> containerAdapter, WebContext context);

	/**
	 * Get set of annotations that is used by T2.
	 * 
	 * @param containerAdapter
	 * @return
	 */
	Set<Class<? extends Annotation>> getActionAnnotationSet(
			ContainerAdapter<?> containerAdapter);

	/**
	 * Create map of Annotation and ActionAnnotationResolver, which is a class
	 * to handle how to behave if the specified method annotation is annotated.
	 * 
	 * @param containerAdapter
	 * @return
	 */
	Map<Class<? extends Annotation>, ActionAnnotationResolver> createActionAnnotationResolvers(
			ContainerAdapter<?> containerAdapter);

	/**
	 * Return default annotation resolver.
	 * 
	 * @param containerAdapter
	 * @return
	 */
	ActionAnnotationResolver createDefaultActionAnnotationResolver(
			ContainerAdapter<?> containerAdapter);

}
