package org.t2framework.plugin;

import java.util.List;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.t2framework.action.ActionContext;
import org.t2framework.contexts.WebContext;
import org.t2framework.contexts.WebApplication;
import org.t2framework.spi.Navigation;

import commons.meta.MethodDesc;

/**
 * PluginProceesor is a processor class for all plugins.
 * 
 * @author shot
 */
public interface PluginProcessor {

	void invokeInit(ServletContext servletContext, WebApplication webApplication);

	void beginRequest(HttpServletRequest request, HttpServletResponse response);

	HttpServletRequest createRequest(HttpServletRequest request,
			HttpServletResponse response);

	HttpServletResponse createResponse(HttpServletRequest request,
			HttpServletResponse response);

	Navigation invokeComponentCreated(WebContext context, Object page);

	Navigation beforeActionInvoke(ActionContext actionContext,
			MethodDesc methodDesc, Object page, Object[] args);

	Navigation afterActionInvoke(ActionContext actionContext,
			MethodDesc methodDesc, Object page, Object[] args);

	void beforeNavigation(WebContext context);

	void afterNavigation(WebContext context);

	void endRequest(HttpServletRequest request, HttpServletResponse response);

	void destroy(ServletContext servletContext, WebApplication webApplication);

	List<Plugin> getPlugins();
}
