package org.t2framework.plugin;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.t2framework.action.ActionContext;
import org.t2framework.contexts.WebContext;
import org.t2framework.contexts.WebApplication;
import org.t2framework.navigation.NoOperation;
import org.t2framework.plugin.Plugin;
import org.t2framework.spi.Navigation;

import commons.meta.MethodDesc;

public class AbstractPlugin implements Plugin {

	@Override
	public void initialize(ServletContext servletContext,
			WebApplication webApplication) {
	}

	@Override
	public void beginRequestProcessing(HttpServletRequest request,
			HttpServletResponse response) {
	}

	@Override
	public HttpServletRequest createRequest(HttpServletRequest request,
			HttpServletResponse response) {
		return request;
	}

	@Override
	public HttpServletResponse createResponse(HttpServletRequest request,
			HttpServletResponse response) {
		return response;
	}

	@Override
	public Navigation componentCreated(WebContext context, Object page) {
		return NoOperation.INSTANCE;
	}

	@Override
	public Navigation beforeActionInvoke(ActionContext actionContext,
			MethodDesc targetMethod, Object page, Object[] args) {
		return NoOperation.INSTANCE;
	}

	@Override
	public Navigation afterActionInvoke(ActionContext actionContext,
			MethodDesc targetMethod, Object page, Object[] args) {
		return NoOperation.INSTANCE;
	}

	@Override
	public void beforeNavigation(WebContext context) {
	}

	@Override
	public void afterNavigation(WebContext context) {
	}

	@Override
	public void endRequestProcessing(HttpServletRequest request,
			HttpServletResponse response) {
	}

	@Override
	public void destroy(ServletContext servletContext,
			WebApplication webApplication) {
	}

}
