package org.t2framework.navigation;

import org.t2framework.spi.Navigation;

import commons.meta.ClassDesc;
import commons.meta.impl.ClassDescImpl;
import commons.util.Assertion;

/**
 * Normal web response base class.
 * 
 * @author shot
 */
public abstract class WebNavigation implements Navigation {

	protected Class<?> pageClass;

	protected String path;

	protected ClassDesc<Object> classDesc;

	public WebNavigation() {
	}

	public WebNavigation(String path) {
		this.path = Assertion.notNull(path);
	}

	public WebNavigation(Class<?> pageClass) {
		this.pageClass = Assertion.notNull(pageClass);
		this.classDesc = new ClassDescImpl<Object>(pageClass);
	}

	public Class<?> getPageClass() {
		return pageClass;
	}

	public void setPageClass(Class<?> pageClass) {
		this.pageClass = pageClass;
	}

	public String getPath() {
		return path;
	}

	public void setPath(String path) {
		this.path = path;
	}

}
