package org.t2framework.navigation;

import org.t2framework.spi.Navigation;

import commons.util.Assertion;

/**
 * Text type of navigation class.
 * 
 * @author shot
 */
public abstract class TextNavigation implements Navigation {

	protected final Object object;

	protected final String text;

	public TextNavigation(Object object) {
		this.object = Assertion.notNull(object);
		this.text = null;
	}

	public TextNavigation(String text) {
		this.object = null;
		this.text = Assertion.notNull(text);
	}

	public Object getObject() {
		return object;
	}

	public String getText() {
		return text;
	}

}
