package org.t2framework.navigation;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

import org.t2framework.spi.Navigation;

import commons.util.Assertion;
import commons.util.StreamUtil;

/**
 * Base class of stream type response.
 * 
 * @author shot
 */
public abstract class StreamNavigation implements Navigation {

	protected byte[] bytes;

	protected InputStream is;

	protected File file;

	public StreamNavigation(File file) {
		this.file = Assertion.notNull(file);
	}

	public StreamNavigation(InputStream is) {
		this.is = Assertion.notNull(is);
	}

	public StreamNavigation(byte[] bytes) {
		this.bytes = Assertion.notNull(bytes);
	}

	public byte[] getBytes() {
		return bytes;
	}

	protected void writeTo(HttpServletResponse res, ServletOutputStream sos)
			throws IOException {
		if (is != null) {
			StreamUtil.copy(is, sos);
		} else if (file != null) {
			StreamUtil
					.copy(StreamUtil.createBufferedFileInputStream(file), sos);
		} else {
			final byte[] bytes = getBytes();
			res.setContentLength(bytes.length);
			sos.write(bytes);
		}
	}

}
