package org.t2framework.navigation;

import org.t2framework.contexts.Response;
import org.t2framework.contexts.WebContext;

import commons.Constants;

public class SimpleText extends TextNavigation {

	public static SimpleText out(String text) {
		return new SimpleText(text);
	}

	public SimpleText(String text) {
		super(text);
	}

	@Override
	public void execute(WebContext context) throws Exception {
		Response response = context.getResponse();
		response.setContentType(Constants.TEXT_CONTENT_TYPE
				+ "; charset="
				+ context.getRequest().getNativeResource()
						.getCharacterEncoding());
		response.writeAndFlush(getText());
	}

}
