package org.t2framework.navigation;

import org.t2framework.annotation.core.Page;
import org.t2framework.contexts.WebContext;
import org.t2framework.exception.InvalidClientCodeRuntimeException;

import commons.meta.ConfigDesc;
import commons.util.JavaBeansUtil;
import commons.util.StringUtil;

/**
 * Redirect response.
 * 
 * @author shot
 */
public class Redirect extends WebNavigation {

	public static Redirect to(String path) {
		return new Redirect(path);
	}

	public static Redirect to(Class<?> pageClass) {
		return new Redirect(pageClass);
	}

	public Redirect(String path) {
		super(path);
	}

	public Redirect(Class<?> pageClass) {
		super(pageClass);
	}

	@Override
	public void execute(WebContext context) throws Exception {
		String realpath = toRealPath(context, path);
		if (pageClass != null) {
			ConfigDesc cd = (ConfigDesc) classDesc.findConfigDesc(Page.class);
			if (cd == null || !cd.hasAnnotation()) {
				throw new InvalidClientCodeRuntimeException();
			}

			Page page = (Page) cd.getAnnotation();
			realpath = page.value();
			if (StringUtil.isEmpty(realpath)) {
				realpath = toRealPath(context, JavaBeansUtil
						.decapitalize(pageClass.getSimpleName()));
			}
		}
		redirect(context, realpath);
	}

	protected String toRealPath(WebContext context, String path) {
		if (path == null) {
			return null;
		}

		if (path.startsWith("/")) {
			return context.getRequest().getContextPath() + path;
		} else if (path.length() == 0 || path.startsWith("?")
				|| path.startsWith(";")) {
			return context.getRequest().getContextPath() + "/" + path;
		}

		return path;
	}

	protected void redirect(WebContext context, String realPath) {
		context.redirect(realPath);
	}

}
