package org.t2framework.navigation;

import org.t2framework.contexts.Response;
import org.t2framework.contexts.WebContext;

import commons.util.JSONSerializer;

/**
 * JSON response.
 * 
 * @author shot
 */
public class Json extends TextNavigation {

	public static Json convert(Object jsonObject) {
		return new Json(jsonObject);
	}

	public Json(Object jsonObject) {
		super(jsonObject);
	}

	@Override
	public void execute(WebContext context) throws Exception {
		Response response = context.getResponse();
		response.setContentType("text/javascript; charset=utf-8");
		response.setNoCache();
		final String json = JSONSerializer.serialize(getObject());
		response.writeAndFlush(json);
	}

}
