package org.t2framework.navigation;

import java.util.Map;

import org.t2framework.annotation.core.Page;
import org.t2framework.contexts.WebContext;

import commons.meta.ConfigDesc;
import commons.util.JavaBeansUtil;
import commons.util.StringUtil;
import commons.util.UrlBuilder;

/**
 * Forward response.
 * 
 * @author shot
 */
public class Forward extends WebNavigation {

	public static Forward to(final Class<?> pageClass) {
		return new Forward(pageClass);
	}

	public static Forward to(final String path) {
		return new Forward(path);
	}

	public Forward(String path) {
		super(path);
	}

	public Forward(Class<?> pageClass) {
		super(pageClass);
	}

	@Override
	public void execute(WebContext context) throws Exception {
		String path = getPath();
		if (pageClass != null) {
			ConfigDesc cd = (ConfigDesc) classDesc.findConfigDesc(Page.class);
			if (cd == null) {
				forward(context, path);
				return;
			}
			if (!cd.hasAnnotation()) {
				return;
			}
			Page page = (Page) cd.getAnnotation();
			path = page.value();
			if (StringUtil.isEmpty(path)) {
				path = JavaBeansUtil.decapitalize(pageClass.getSimpleName());
			}
		}
		String realpath = buildForwardPath(context, path);
		forward(context, realpath);
	}

	protected String buildForwardPath(WebContext context, String path) {
		final UrlBuilder builder = new UrlBuilder(path);
		final Map<String, Object> params = context.getRequest()
				.getAttributesAsMap();
		if (!params.isEmpty()) {
			builder.addAll(params);
		}
		return builder.build();
	}

	protected void forward(WebContext context, String path) {
		context.forward(path);
	}
}
