package org.t2framework.navigation;

import java.io.File;
import java.io.InputStream;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

import org.t2framework.contexts.WebContext;

import commons.util.Assertion;

/**
 * Direct output returns as response like returning binary response.
 * 
 * <pre>
 * Direct takes three parameter to write to ServletOutputStream :
 *  -File
 *  -InputStream
 *  -bytes[]
 * </pre>
 * 
 * @author shot
 */
public class Direct extends StreamNavigation {

	public static Direct from(File file) {
		return new Direct(Assertion.notNull(file));
	}

	public static Direct from(InputStream is) {
		return new Direct(Assertion.notNull(is));
	}

	public static Direct to(byte[] bytes) {
		return new Direct(Assertion.notNull(bytes));
	}

	public Direct(byte[] bytes) {
		super(bytes);
	}

	public Direct(File file) {
		super(file);
	}

	public Direct(InputStream is) {
		super(is);
	}

	@Override
	public void execute(WebContext context) throws Exception {
		final HttpServletResponse res = context.getResponse()
				.getNativeResource();
		// TODO : if user cancel download, then should we log it instead of
		// print stack trace?
		ServletOutputStream sos = res.getOutputStream();
		super.writeTo(res, sos);
		sos.flush();
	}

}
