package org.t2framework.mock;

import org.t2framework.contexts.Application;
import org.t2framework.contexts.Chain;
import org.t2framework.contexts.Request;
import org.t2framework.contexts.Response;
import org.t2framework.contexts.Session;
import org.t2framework.contexts.WebContext;
import org.t2framework.contexts.impl.ApplicationImpl;
import org.t2framework.contexts.impl.RequestImpl;
import org.t2framework.contexts.impl.ResponseImpl;
import org.t2framework.contexts.impl.SessionImpl;

import commons.mock.MockFilterConfig;
import commons.mock.MockFilterConfigImpl;
import commons.mock.MockHttpServletRequest;
import commons.mock.MockHttpServletRequestImpl;
import commons.mock.MockHttpServletResponse;
import commons.mock.MockHttpServletResponseImpl;
import commons.mock.MockHttpSession;
import commons.mock.MockServletContext;
import commons.mock.MockServletContextImpl;

public class MockWebContext extends WebContext {

	protected Request request;

	protected Response response;

	protected Application application;

	protected Session session;

	protected MockHttpServletRequest mockRequest;

	protected MockHttpServletResponse mockResponse;

	protected MockServletContext mockServletContext;

	protected MockHttpSession mockSession;

	public static MockWebContext createMock(final String requestPath) {
		return createMock(null, requestPath);
	}

	public static MockWebContext createMock(final String path,
			final String requestPath) {
		MockServletContext context = new MockServletContextImpl(path);
		MockHttpServletRequest request = new MockHttpServletRequestImpl(
				context, requestPath);
		MockHttpServletResponse response = new MockHttpServletResponseImpl(
				request);
		MockHttpSession session = MockHttpSession.class.cast(request
				.getSession());
		MockFilterConfig config = new MockFilterConfigImpl(context);
		MockWebContext mock = new MockWebContext(request, response, context,
				session, config);
		WebContext.set(mock);
		return mock;
	}

	public MockWebContext(final MockHttpServletRequest req,
			final MockHttpServletResponse res,
			final MockServletContext context, final MockHttpSession ses,
			final MockFilterConfig config) {
		this.request = new RequestImpl(req, res, true);
		this.response = new ResponseImpl(res);
		this.application = new ApplicationImpl(context, config);
		this.session = new SessionImpl(request);
		this.mockRequest = req;
		this.mockResponse = res;
		this.mockSession = ses;
		this.mockServletContext = context;
	}

	@Override
	public Application getApplication() {
		return application;
	}

	@Override
	public Request getRequest() {
		return request;
	}

	@Override
	public Response getResponse() {
		return response;
	}

	@Override
	public Session getSession() {
		return session;
	}

	public MockHttpServletRequest getMockHttpServletRequest() {
		return mockRequest;
	}

	public MockHttpServletResponse getMockHttpServletResponse() {
		return mockResponse;
	}

	public MockHttpSession getMockHttpSession() {
		return mockSession;
	}

	public MockServletContext getMockServletContext() {
		return mockServletContext;
	}

	@Override
	public Chain getChain() {
		return null;
	}

}
