package org.t2framework.mock;

import org.t2framework.contexts.impl.RequestImpl;

import commons.mock.MockHttpServletRequest;
import commons.mock.MockHttpServletRequestImpl;
import commons.mock.MockHttpServletResponseImpl;
import commons.mock.MockServletContextImpl;

public class MockRequestImpl extends RequestImpl implements MockRequest {

	protected MockHttpServletRequest mockRequest;

	public MockRequestImpl(String requestPath) {
		this(null, requestPath);
	}

	public MockRequestImpl(String contextPath, String requestPath) {
		this(new MockHttpServletRequestImpl(new MockServletContextImpl(
				contextPath), requestPath));
	}

	protected MockRequestImpl(MockHttpServletRequest request) {
		super(request, new MockHttpServletResponseImpl(request));
		this.mockRequest = request;
	}

	@Override
	public void addParameter(String name, String value) {
		mockRequest.addParameter(name, value);
	}

}