package org.t2framework.mock;

import java.lang.annotation.Annotation;
import java.util.Set;

import org.t2framework.annotation.composite.GET;
import org.t2framework.annotation.composite.POST;
import org.t2framework.annotation.core.ActionParam;
import org.t2framework.annotation.core.ActionPath;
import org.t2framework.contexts.impl.PageDescImpl;
import org.t2framework.util.impl.UrlTemplateImpl;

import commons.meta.BeanDescFactory;
import commons.util.Assertion;
import commons.util.CollectionsUtil;
import commons.util.Reflections.PackageUtil;

public class MockPageDescImpl extends PageDescImpl {

	public static Set<Class<? extends Annotation>> actionAnnotationSet = CollectionsUtil
			.newHashSet();

	static {
		actionAnnotationSet.add(ActionParam.class);
		actionAnnotationSet.add(ActionPath.class);
		actionAnnotationSet.add(GET.class);
		actionAnnotationSet.add(POST.class);
	}

	public MockPageDescImpl(final Class<?> clazz, final String path) {
		super(PackageUtil.getPackageName(Assertion.notNull(clazz)), clazz
				.getSimpleName(), BeanDescFactory.getBeanDesc(clazz),
				new UrlTemplateImpl(path), actionAnnotationSet);
	}
}
